using System;
using System.ComponentModel;
using System.Drawing;
using BLOODPRODUCT = gov.va.med.vbecs.Common.VbecsTables.BloodProduct;
using BLOODTESTTYPE = gov.va.med.vbecs.Common.VbecsTables.BloodTestType;
using BLOODUNITANTIGEN = gov.va.med.vbecs.Common.VbecsTables.BloodUnitAntigen;
using ANTIGENTYPE = gov.va.med.vbecs.Common.VbecsTables.AntigenType;
using ANTIGENTEST = gov.va.med.vbecs.Common.VbecsTables.AntigenTest;
using ANTIBODYTYPE = gov.va.med.vbecs.Common.VbecsTables.AntibodyType;
using TESTRESULT = gov.va.med.vbecs.Common.VbecsTables.TestResult;
using PATIENT = gov.va.med.vbecs.Common.VbecsTables.Patient;
using PATIENTSPECIMEN = gov.va.med.vbecs.Common.VbecsTables.PatientSpecimen;
using System.Windows.Forms;
using System.Collections;
using System.Data;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmModifyUnits
	/// </summary>
	public class FrmModifyUnits : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables
		private System.Windows.Forms.Control _genericControl ;
		/// <summary>
		/// Might need a collection of these bastards to get the shibby goin..
		/// OOH!  Create a collection, then, for single unit modifications...hmmmm .. i forgot
		/// </summary>
		private BOL.BloodUnitModification _currentBUM;

		/// <summary>
		/// Arraylist of our modification controls
		/// </summary>
		private System.Collections.ArrayList _bumControlList;

		private bool _autoCalculate = false;

		private bool _isFirstTime = true;

		private System.Windows.Forms.Keys _keyCode;
		private bool _bShift = false;

		/// <summary>
		/// Is the form being populated via code
		/// </summary>
		private bool _isLoading = false;

		/// <summary>
		/// If multiple units are being processed at one time, this will be set to False.  Just kidding, it'll be set to true.
		/// </summary>
		private bool _isMultiple = false;

		/// <summary>
		/// Needed for CreateTargetTabs
		/// </summary>
		private bool _removingTabs = false;

		/// <summary>
		/// Arraylist to coinicide with the target product dropdown so we don't have a dataTable reference
		/// </summary>
		private System.Collections.ArrayList _targetProductList;
		private System.Collections.ArrayList _btnOKRowVersionException = new ArrayList();

		#endregion

		#region Form Controls
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Panel pnlModify;
		private System.Windows.Forms.Label lblModificationDate;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.TextBox txtModificationDate;
		private System.Windows.Forms.PictureBox picUnit;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.GroupBox grpModificationDate;
		private System.Windows.Forms.RadioButton rdoIncomplete;
		private System.Windows.Forms.RadioButton rdoComplete;
		private System.Windows.Forms.TextBox txtMethod;
		private System.Windows.Forms.Label lblMethod;
		private System.Windows.Forms.GroupBox grpWeld;
		private System.Windows.Forms.Panel pnlTop;
		private System.Windows.Forms.TabControl tabTargets;
		private System.Windows.Forms.TabPage pageTarget1;
		private System.Windows.Forms.Panel pnltarget;
		private System.Windows.Forms.TabControl tabSuppliesEquipment;
		private System.Windows.Forms.TabPage pageContainer;
		private System.Windows.Forms.Button btnAddContainer;
		private System.Windows.Forms.ListView lvContainer;
		private System.Windows.Forms.TabPage pageSupplies;
		private System.Windows.Forms.Button btnAddSupplies;
		private System.Windows.Forms.ListView lvSupplies;
		private System.Windows.Forms.TabPage pageEquipment;
		private System.Windows.Forms.Button btnAddEquipment;
		private System.Windows.Forms.ListView lvEquipment;
		private System.Windows.Forms.TabPage pageSCDWafer;
		private System.Windows.Forms.Button btnAddWafer;
		private System.Windows.Forms.ListView lvSCDWafer;
		private System.Windows.Forms.Panel pnlTargetExtraInfo;
		private System.Windows.Forms.TabControl tabTargetExtraInfo;
		private System.Windows.Forms.TabPage pageTargetRestricted;
		private System.Windows.Forms.PictureBox picTargetBiohazard;
		private System.Windows.Forms.TextBox txtTargetRestrictedStatus;
		private System.Windows.Forms.Label lblTargetTestingStatus;
		private System.Windows.Forms.TextBox txtTargetRestrictedSSN;
		private System.Windows.Forms.TextBox txtTargetRestrictedName;
		private System.Windows.Forms.Label lblTargetRestrictedSSN;
		private System.Windows.Forms.Label lblTargetRestrictedName;
		private System.Windows.Forms.TabPage pageTargetAssigned;
		private System.Windows.Forms.ListView lvTargetAssigned;
		private System.Windows.Forms.TabPage pageTargetSpecialTesting;
		private System.Windows.Forms.Label lblTargetSickleCellNeg;
		private System.Windows.Forms.Label lblTargetCMVNeg;
		private System.Windows.Forms.ListView lvTargetAntigens;
		private System.Windows.Forms.Label lblTargetRBCAntigens;
		private System.Windows.Forms.CheckBox cbTargetSickleCellNeg;
		private System.Windows.Forms.CheckBox cbTargetCMVNeg;
		private System.Windows.Forms.TextBox txtTargetDonationType;
		private System.Windows.Forms.Label lblTargetDonationType;
		private System.Windows.Forms.Panel pnlTargetUnitInfo;
		private System.Windows.Forms.TextBox txtTargetUnitStatus;
		private System.Windows.Forms.Label lblTargetUnitStatus;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updTargetVolume;
		private System.Windows.Forms.TextBox txtTargetABORh;
		private System.Windows.Forms.TextBox txtTargetUnitId;
		private System.Windows.Forms.DateTimePicker dtpTargetExpirationDate;
		private System.Windows.Forms.Label lblTargetVolume;
		private System.Windows.Forms.Label lblTargetProductName;
		private System.Windows.Forms.Label lblTargetExpirationDate;
		private System.Windows.Forms.Label lblTargetABORh;
		private System.Windows.Forms.Label lblTargetUnitId;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader colSupplyCheckbox;
		private System.Windows.Forms.ColumnHeader colSupplyLotNumber;
		private System.Windows.Forms.ColumnHeader colSupplyName;
		private System.Windows.Forms.ColumnHeader colSupplyManufacturer;
		private System.Windows.Forms.ColumnHeader colSupplyExpires;
		private System.Windows.Forms.ColumnHeader colEquipmentCheckbox;
		private System.Windows.Forms.ColumnHeader colSerialNumber;
		private System.Windows.Forms.ColumnHeader colEquipmentName;
		private System.Windows.Forms.ColumnHeader colEquipmentManufacturer;
		private System.Windows.Forms.ColumnHeader colLocalID;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.ColumnHeader columnHeader9;
		private System.Windows.Forms.ColumnHeader columnHeader10;
		private System.Windows.Forms.ColumnHeader columnHeader11;
		private System.Windows.Forms.ColumnHeader columnHeader12;
		private System.Windows.Forms.ColumnHeader colTargetAntigens;
		private System.Windows.Forms.ColumnHeader colTargetPosNeg;
		private System.Windows.Forms.TabPage pageOriginalUnit1;
		private System.Windows.Forms.Panel pnlOriginalUnitInfo;
		private System.Windows.Forms.Label lblOriginalVolume;
		private System.Windows.Forms.TextBox txtOriginalUnitStatus;
		private System.Windows.Forms.Label lblOriginalUnitStatus;
		private System.Windows.Forms.TextBox txtOriginalProductName;
		private System.Windows.Forms.TextBox txtOriginalABORh;
		private System.Windows.Forms.TextBox txtOriginalUnitID;
		private System.Windows.Forms.Label lblOriginalProductName;
		private System.Windows.Forms.TextBox txtOriginalExpirationDate;
		private System.Windows.Forms.Label lblOriginalExpirationDate;
		private System.Windows.Forms.Label lblOriginalABORh;
		private System.Windows.Forms.Label lblOriginalUnitID;
		private System.Windows.Forms.TabControl tabOriginals;
		private System.Windows.Forms.Panel pnlOriginalExtraInfo;
		private System.Windows.Forms.TabControl tabOriginalExtraInfo;
		private System.Windows.Forms.TabPage pageOriginalRestricted;
		private System.Windows.Forms.PictureBox picOriginalBiohazard;
		private System.Windows.Forms.TextBox txtOriginalRestrictedStatus;
		private System.Windows.Forms.Label lblOriginalRestrictedStatus;
		private System.Windows.Forms.TextBox txtOriginalRestrictedSSN;
		private System.Windows.Forms.TextBox txtOriginalRestrictedName;
		private System.Windows.Forms.Label lblOriginalRestrictedSSN;
		private System.Windows.Forms.Label lblOriginalRestrictedName;
		private System.Windows.Forms.TabPage pageOriginalAssigned;
		private System.Windows.Forms.TabPage pageOriginalSpecialTesting;
		private System.Windows.Forms.Label lblOriginalSickleCellNeg;
		private System.Windows.Forms.Label lblOriginalCMVNeg;
		private System.Windows.Forms.ListView lvOriginalAntigens;
		private System.Windows.Forms.Label lblOriginalRBCAntigens;
		private System.Windows.Forms.CheckBox cbOriginalSickleCellNeg;
		private System.Windows.Forms.CheckBox cbOriginalCMVNeg;
		private System.Windows.Forms.TextBox txtOriginalDonationType;
		private System.Windows.Forms.Label lblOriginalDonationType;
		private System.Windows.Forms.ColumnHeader columnHeader13;
		private System.Windows.Forms.ColumnHeader columnHeader14;
		private System.Windows.Forms.ColumnHeader columnHeader15;
		private System.Windows.Forms.ColumnHeader columnHeader16;
		private System.Windows.Forms.ColumnHeader colOriginalAntigen;
		private System.Windows.Forms.ColumnHeader colOriginalPosNeg;
		private System.Windows.Forms.ComboBox cmbTargetProductName;
		private System.Windows.Forms.ListView lvOriginalAssigned;
		private System.Windows.Forms.Panel pnlTargetUnit;
		private System.Windows.Forms.Panel pnlTargetUnitTop;
		private System.Windows.Forms.Panel pnlOriginalUnit;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updOriginalVolume;
        private Timer timer1;
		private System.ComponentModel.IContainer components = null;
		#endregion

		#region Constructors/Destructors


		/// <summary>
		/// Constructor
		/// </summary>
		public FrmModifyUnits(System.Collections.ArrayList bumControlList)
		{
            this.LockController.LockFunction = Common.LockFunctions.UC026ModifyUnits;

			this._isLoading = true;
            //LOCKING420 - Moved Guids to LockManager - was sort of playing around, trying to make things easier for the developer
            //we can remove if you don't want it here.. or rename.. 
			foreach (BOL.BloodUnitModification lockBUM in bumControlList)
			{
				//Need BloodUnitMedia lock for ExpirationDate change
                this.LockController.RecordGuids.Add(lockBUM.OriginalUnit.BloodUnitMedia.BloodUnitMediaGuid);

				//Need BloodUnitStatus record, because label verification failure will quarantine the unit
                this.LockController.RecordGuids.Add(lockBUM.OriginalUnit.BloodUnitStatus.BloodUnitStatusGuid);

				//Adding Finance record, because modification costs are added to the new unit
                this.LockController.RecordGuids.Add(lockBUM.OriginalUnit.BloodUnitFinance.BloodUnitFinanceGuid);

				//For Volume Reduce, we will update the DiscardPlasma
                this.LockController.RecordGuids.Add(lockBUM.OriginalUnit.BloodUnitGuid);

				//Lock the OrderedUnits (if any)
				foreach(BOL.Patient tmpPatient in lockBUM.OriginalUnit.AssignedToPatients)
				{
					BOL.OrderedUnit tmpOU = new BOL.OrderedUnit(lockBUM.OriginalUnit.BloodUnitGuid, tmpPatient.PatientGuid);
                    this.LockController.RecordGuids.Add(tmpOU.OrderedUnitGuid);
				}
			}

			if (!this.SetLocks())
			{
				this.DialogResult = DialogResult.Abort;
				return;
			}

			InitializeComponent();

			//We technically don't need a currentBUM because it's inside the bumControl
			this._bumControlList = bumControlList;
			this._currentBUM = (BOL.BloodUnitModification)bumControlList[0];

			SetComponentProperties();

			this.CreateTabs();
			
			this.PopulateSourceDetails();				
			this.PopulateTargetDetails();

			//Attach all our events/broken rules for each control in our Arraylist
			for (int ndx=0; ndx < this._bumControlList.Count; ndx++)
			{
				BOL.BloodUnitModification bumControl = (BOL.BloodUnitModification)this._bumControlList[ndx];
				
				//Set the RowVersionException value for each modification in batch
				this._btnOKRowVersionException.Add(false);

				//Set the broken rules for this cluster
				bumControl.SetInitialBrokenRules(this.Name, string.Empty);

				//Attach the events
				bumControl.Valid += new System.EventHandler(this.ObjectValidityChange);
				bumControl.Invalid += new System.EventHandler(this.ObjectValidityChange);
				bumControl.ModifiedUnitStateChange += new EventHandler(this.ObjectValidityChange);
				bumControl.WeldIndicatorChanged += new System.EventHandler(this.RefreshExpirationDate);
			}

			this._currentBUM = (BOL.BloodUnitModification)bumControlList[0];

			//This fires off just to make sure the OK button is enabled properly with the right text
			this.ObjectValidityChange(this,System.EventArgs.Empty);

			this._isMultiple = (bumControlList.Count > 1);

			//The WeldCompletenessIndicator has TabIndex = 0, which will automatically select
			//on form load.  This will prevent that, and force user selection.
			if (this._currentBUM.ModificationMethod == Common.ModifyUnitMethod.SterileConnectingDevice)
			{
				this.btnCancel.TabIndex = 0;
			}

			this._isLoading = false;

			this._isFirstTime = false;
		}

		#endregion

		#region Designer generated code

		/// <summary>
		/// Dispose
		/// </summary>
		/// <param name="disposing"></param>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmModifyUnits));
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancel = new System.Windows.Forms.Button();
            this.pnlModify = new System.Windows.Forms.Panel();
            this.pnlTargetUnit = new System.Windows.Forms.Panel();
            this.pnltarget = new System.Windows.Forms.Panel();
            this.tabSuppliesEquipment = new System.Windows.Forms.TabControl();
            this.pageContainer = new System.Windows.Forms.TabPage();
            this.btnAddContainer = new System.Windows.Forms.Button();
            this.lvContainer = new System.Windows.Forms.ListView();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.pageSupplies = new System.Windows.Forms.TabPage();
            this.btnAddSupplies = new System.Windows.Forms.Button();
            this.lvSupplies = new System.Windows.Forms.ListView();
            this.colSupplyCheckbox = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colSupplyLotNumber = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colSupplyName = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colSupplyManufacturer = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colSupplyExpires = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.pageEquipment = new System.Windows.Forms.TabPage();
            this.btnAddEquipment = new System.Windows.Forms.Button();
            this.lvEquipment = new System.Windows.Forms.ListView();
            this.colEquipmentCheckbox = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colSerialNumber = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colEquipmentName = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colEquipmentManufacturer = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colLocalID = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.pageSCDWafer = new System.Windows.Forms.TabPage();
            this.btnAddWafer = new System.Windows.Forms.Button();
            this.lvSCDWafer = new System.Windows.Forms.ListView();
            this.columnHeader5 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader6 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader7 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader8 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.pnlTargetUnitTop = new System.Windows.Forms.Panel();
            this.pnlTargetExtraInfo = new System.Windows.Forms.Panel();
            this.tabTargetExtraInfo = new System.Windows.Forms.TabControl();
            this.pageTargetRestricted = new System.Windows.Forms.TabPage();
            this.picTargetBiohazard = new System.Windows.Forms.PictureBox();
            this.txtTargetRestrictedStatus = new System.Windows.Forms.TextBox();
            this.lblTargetTestingStatus = new System.Windows.Forms.Label();
            this.txtTargetRestrictedSSN = new System.Windows.Forms.TextBox();
            this.txtTargetRestrictedName = new System.Windows.Forms.TextBox();
            this.lblTargetRestrictedSSN = new System.Windows.Forms.Label();
            this.lblTargetRestrictedName = new System.Windows.Forms.Label();
            this.pageTargetAssigned = new System.Windows.Forms.TabPage();
            this.lvTargetAssigned = new System.Windows.Forms.ListView();
            this.columnHeader9 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader10 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader11 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader12 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.pageTargetSpecialTesting = new System.Windows.Forms.TabPage();
            this.lblTargetSickleCellNeg = new System.Windows.Forms.Label();
            this.lblTargetCMVNeg = new System.Windows.Forms.Label();
            this.lvTargetAntigens = new System.Windows.Forms.ListView();
            this.colTargetAntigens = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colTargetPosNeg = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.lblTargetRBCAntigens = new System.Windows.Forms.Label();
            this.cbTargetSickleCellNeg = new System.Windows.Forms.CheckBox();
            this.cbTargetCMVNeg = new System.Windows.Forms.CheckBox();
            this.txtTargetDonationType = new System.Windows.Forms.TextBox();
            this.lblTargetDonationType = new System.Windows.Forms.Label();
            this.pnlTargetUnitInfo = new System.Windows.Forms.Panel();
            this.cmbTargetProductName = new System.Windows.Forms.ComboBox();
            this.txtTargetUnitStatus = new System.Windows.Forms.TextBox();
            this.lblTargetUnitStatus = new System.Windows.Forms.Label();
            this.updTargetVolume = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
            this.txtTargetABORh = new System.Windows.Forms.TextBox();
            this.txtTargetUnitId = new System.Windows.Forms.TextBox();
            this.dtpTargetExpirationDate = new System.Windows.Forms.DateTimePicker();
            this.lblTargetVolume = new System.Windows.Forms.Label();
            this.lblTargetProductName = new System.Windows.Forms.Label();
            this.lblTargetExpirationDate = new System.Windows.Forms.Label();
            this.lblTargetABORh = new System.Windows.Forms.Label();
            this.lblTargetUnitId = new System.Windows.Forms.Label();
            this.pnlOriginalUnit = new System.Windows.Forms.Panel();
            this.pnlOriginalExtraInfo = new System.Windows.Forms.Panel();
            this.tabOriginalExtraInfo = new System.Windows.Forms.TabControl();
            this.pageOriginalRestricted = new System.Windows.Forms.TabPage();
            this.picOriginalBiohazard = new System.Windows.Forms.PictureBox();
            this.txtOriginalRestrictedStatus = new System.Windows.Forms.TextBox();
            this.lblOriginalRestrictedStatus = new System.Windows.Forms.Label();
            this.txtOriginalRestrictedSSN = new System.Windows.Forms.TextBox();
            this.txtOriginalRestrictedName = new System.Windows.Forms.TextBox();
            this.lblOriginalRestrictedSSN = new System.Windows.Forms.Label();
            this.lblOriginalRestrictedName = new System.Windows.Forms.Label();
            this.pageOriginalAssigned = new System.Windows.Forms.TabPage();
            this.lvOriginalAssigned = new System.Windows.Forms.ListView();
            this.columnHeader13 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader14 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader15 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader16 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.pageOriginalSpecialTesting = new System.Windows.Forms.TabPage();
            this.lblOriginalSickleCellNeg = new System.Windows.Forms.Label();
            this.lblOriginalCMVNeg = new System.Windows.Forms.Label();
            this.lvOriginalAntigens = new System.Windows.Forms.ListView();
            this.colOriginalAntigen = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colOriginalPosNeg = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.lblOriginalRBCAntigens = new System.Windows.Forms.Label();
            this.cbOriginalSickleCellNeg = new System.Windows.Forms.CheckBox();
            this.cbOriginalCMVNeg = new System.Windows.Forms.CheckBox();
            this.txtOriginalDonationType = new System.Windows.Forms.TextBox();
            this.lblOriginalDonationType = new System.Windows.Forms.Label();
            this.pnlOriginalUnitInfo = new System.Windows.Forms.Panel();
            this.updOriginalVolume = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
            this.lblOriginalVolume = new System.Windows.Forms.Label();
            this.txtOriginalUnitStatus = new System.Windows.Forms.TextBox();
            this.lblOriginalUnitStatus = new System.Windows.Forms.Label();
            this.txtOriginalProductName = new System.Windows.Forms.TextBox();
            this.txtOriginalABORh = new System.Windows.Forms.TextBox();
            this.txtOriginalUnitID = new System.Windows.Forms.TextBox();
            this.lblOriginalProductName = new System.Windows.Forms.Label();
            this.txtOriginalExpirationDate = new System.Windows.Forms.TextBox();
            this.lblOriginalExpirationDate = new System.Windows.Forms.Label();
            this.lblOriginalABORh = new System.Windows.Forms.Label();
            this.lblOriginalUnitID = new System.Windows.Forms.Label();
            this.tabOriginals = new System.Windows.Forms.TabControl();
            this.pageOriginalUnit1 = new System.Windows.Forms.TabPage();
            this.tabTargets = new System.Windows.Forms.TabControl();
            this.pageTarget1 = new System.Windows.Forms.TabPage();
            this.pnlTop = new System.Windows.Forms.Panel();
            this.grpModificationDate = new System.Windows.Forms.GroupBox();
            this.txtModificationDate = new System.Windows.Forms.TextBox();
            this.txtMethod = new System.Windows.Forms.TextBox();
            this.lblMethod = new System.Windows.Forms.Label();
            this.lblModificationDate = new System.Windows.Forms.Label();
            this.grpWeld = new System.Windows.Forms.GroupBox();
            this.rdoIncomplete = new System.Windows.Forms.RadioButton();
            this.rdoComplete = new System.Windows.Forms.RadioButton();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picUnit = new System.Windows.Forms.PictureBox();
            this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
            this.timer1 = new System.Windows.Forms.Timer(this.components);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.pnlModify.SuspendLayout();
            this.pnlTargetUnit.SuspendLayout();
            this.pnltarget.SuspendLayout();
            this.tabSuppliesEquipment.SuspendLayout();
            this.pageContainer.SuspendLayout();
            this.pageSupplies.SuspendLayout();
            this.pageEquipment.SuspendLayout();
            this.pageSCDWafer.SuspendLayout();
            this.pnlTargetUnitTop.SuspendLayout();
            this.pnlTargetExtraInfo.SuspendLayout();
            this.tabTargetExtraInfo.SuspendLayout();
            this.pageTargetRestricted.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picTargetBiohazard)).BeginInit();
            this.pageTargetAssigned.SuspendLayout();
            this.pageTargetSpecialTesting.SuspendLayout();
            this.pnlTargetUnitInfo.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.updTargetVolume)).BeginInit();
            this.pnlOriginalUnit.SuspendLayout();
            this.pnlOriginalExtraInfo.SuspendLayout();
            this.tabOriginalExtraInfo.SuspendLayout();
            this.pageOriginalRestricted.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picOriginalBiohazard)).BeginInit();
            this.pageOriginalAssigned.SuspendLayout();
            this.pageOriginalSpecialTesting.SuspendLayout();
            this.pnlOriginalUnitInfo.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.updOriginalVolume)).BeginInit();
            this.tabOriginals.SuspendLayout();
            this.tabTargets.SuspendLayout();
            this.pnlTop.SuspendLayout();
            this.grpModificationDate.SuspendLayout();
            this.grpWeld.SuspendLayout();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picUnit)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(624, 30);
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 509);
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(464, 500);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 47;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            this.btnOK.Leave += new System.EventHandler(this.btnOK_Leave);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(544, 500);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 48;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            this.btnCancel.Leave += new System.EventHandler(this.btnCancel_Leave);
            // 
            // pnlModify
            // 
            this.pnlModify.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlModify.Controls.Add(this.pnlTargetUnit);
            this.pnlModify.Controls.Add(this.pnlOriginalUnit);
            this.pnlModify.Controls.Add(this.tabOriginals);
            this.pnlModify.Controls.Add(this.tabTargets);
            this.pnlModify.Controls.Add(this.pnlTop);
            this.pnlModify.Controls.Add(this.grpImage);
            this.pnlModify.Location = new System.Drawing.Point(4, 32);
            this.pnlModify.Name = "pnlModify";
            this.pnlModify.Size = new System.Drawing.Size(620, 464);
            this.pnlModify.TabIndex = 0;
            // 
            // pnlTargetUnit
            // 
            this.pnlTargetUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlTargetUnit.Controls.Add(this.pnltarget);
            this.pnlTargetUnit.Controls.Add(this.pnlTargetUnitTop);
            this.pnlTargetUnit.Location = new System.Drawing.Point(60, 240);
            this.pnlTargetUnit.Name = "pnlTargetUnit";
            this.pnlTargetUnit.Size = new System.Drawing.Size(556, 216);
            this.pnlTargetUnit.TabIndex = 49;
            // 
            // pnltarget
            // 
            this.pnltarget.Controls.Add(this.tabSuppliesEquipment);
            this.pnltarget.Dock = System.Windows.Forms.DockStyle.Fill;
            this.pnltarget.Location = new System.Drawing.Point(0, 124);
            this.pnltarget.Name = "pnltarget";
            this.pnltarget.Size = new System.Drawing.Size(556, 92);
            this.pnltarget.TabIndex = 2;
            // 
            // tabSuppliesEquipment
            // 
            this.tabSuppliesEquipment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.tabSuppliesEquipment.Controls.Add(this.pageContainer);
            this.tabSuppliesEquipment.Controls.Add(this.pageSupplies);
            this.tabSuppliesEquipment.Controls.Add(this.pageEquipment);
            this.tabSuppliesEquipment.Controls.Add(this.pageSCDWafer);
            this.tabSuppliesEquipment.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.tabSuppliesEquipment.Location = new System.Drawing.Point(0, 0);
            this.tabSuppliesEquipment.Multiline = true;
            this.tabSuppliesEquipment.Name = "tabSuppliesEquipment";
            this.tabSuppliesEquipment.SelectedIndex = 0;
            this.tabSuppliesEquipment.Size = new System.Drawing.Size(556, 92);
            this.tabSuppliesEquipment.TabIndex = 38;
            this.tabSuppliesEquipment.SelectedIndexChanged += new System.EventHandler(this.tabSuppliesEquipment_SelectedIndexChanged);
            this.tabSuppliesEquipment.Leave += new System.EventHandler(this.tabSuppliesEquipment_Leave);
            // 
            // pageContainer
            // 
            this.pageContainer.Controls.Add(this.btnAddContainer);
            this.pageContainer.Controls.Add(this.lvContainer);
            this.pageContainer.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.pageContainer.Location = new System.Drawing.Point(4, 21);
            this.pageContainer.Name = "pageContainer";
            this.pageContainer.Size = new System.Drawing.Size(548, 67);
            this.pageContainer.TabIndex = 2;
            this.pageContainer.Text = "Container";
            // 
            // btnAddContainer
            // 
            this.btnAddContainer.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnAddContainer.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.btnAddContainer.Location = new System.Drawing.Point(456, 4);
            this.btnAddContainer.Name = "btnAddContainer";
            this.btnAddContainer.Size = new System.Drawing.Size(92, 23);
            this.btnAddContainer.TabIndex = 40;
            this.btnAddContainer.Text = "&Add Container";
            this.btnAddContainer.Click += new System.EventHandler(this.btnAddContainer_Click);
            this.btnAddContainer.Leave += new System.EventHandler(this.btnAddContainer_Leave);
            // 
            // lvContainer
            // 
            this.lvContainer.AccessibleDescription = "Container";
            this.lvContainer.AccessibleName = "Container";
            this.lvContainer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvContainer.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2,
            this.columnHeader3,
            this.columnHeader4});
            this.lvContainer.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lvContainer.FullRowSelect = true;
            this.lvContainer.Location = new System.Drawing.Point(0, 0);
            this.lvContainer.MultiSelect = false;
            this.lvContainer.Name = "lvContainer";
            this.lvContainer.Size = new System.Drawing.Size(452, 56);
            this.lvContainer.TabIndex = 39;
            this.lvContainer.UseCompatibleStateImageBehavior = false;
            this.lvContainer.View = System.Windows.Forms.View.Details;
            this.lvContainer.Leave += new System.EventHandler(this.lvContainer_Leave);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "Lot Number";
            this.columnHeader1.Width = 70;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Supply Type";
            this.columnHeader2.Width = 150;
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "Manufacturer";
            this.columnHeader3.Width = 120;
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "Expires";
            this.columnHeader4.Width = 80;
            // 
            // pageSupplies
            // 
            this.pageSupplies.Controls.Add(this.btnAddSupplies);
            this.pageSupplies.Controls.Add(this.lvSupplies);
            this.pageSupplies.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.pageSupplies.Location = new System.Drawing.Point(4, 21);
            this.pageSupplies.Name = "pageSupplies";
            this.pageSupplies.Size = new System.Drawing.Size(548, 67);
            this.pageSupplies.TabIndex = 0;
            this.pageSupplies.Text = "Supplies";
            this.pageSupplies.Visible = false;
            // 
            // btnAddSupplies
            // 
            this.btnAddSupplies.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnAddSupplies.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.btnAddSupplies.Location = new System.Drawing.Point(456, 4);
            this.btnAddSupplies.Name = "btnAddSupplies";
            this.btnAddSupplies.Size = new System.Drawing.Size(92, 23);
            this.btnAddSupplies.TabIndex = 42;
            this.btnAddSupplies.Text = "Add &Supplies";
            this.btnAddSupplies.Click += new System.EventHandler(this.btnAddSupplies_Click);
            this.btnAddSupplies.Leave += new System.EventHandler(this.btnAddSupplies_Leave);
            // 
            // lvSupplies
            // 
            this.lvSupplies.AccessibleDescription = "Supplies";
            this.lvSupplies.AccessibleName = "Supplies";
            this.lvSupplies.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvSupplies.CheckBoxes = true;
            this.lvSupplies.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.colSupplyCheckbox,
            this.colSupplyLotNumber,
            this.colSupplyName,
            this.colSupplyManufacturer,
            this.colSupplyExpires});
            this.lvSupplies.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lvSupplies.FullRowSelect = true;
            this.lvSupplies.Location = new System.Drawing.Point(0, 0);
            this.lvSupplies.MultiSelect = false;
            this.lvSupplies.Name = "lvSupplies";
            this.lvSupplies.Size = new System.Drawing.Size(452, 66);
            this.lvSupplies.TabIndex = 41;
            this.lvSupplies.UseCompatibleStateImageBehavior = false;
            this.lvSupplies.View = System.Windows.Forms.View.Details;
            this.lvSupplies.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvSupplies_ItemCheck);
            this.lvSupplies.Leave += new System.EventHandler(this.lvSupplies_Leave);
            // 
            // colSupplyCheckbox
            // 
            this.colSupplyCheckbox.Text = "";
            this.colSupplyCheckbox.Width = 20;
            // 
            // colSupplyLotNumber
            // 
            this.colSupplyLotNumber.Text = "Lot Number";
            this.colSupplyLotNumber.Width = 70;
            // 
            // colSupplyName
            // 
            this.colSupplyName.Text = "Supply Type";
            this.colSupplyName.Width = 150;
            // 
            // colSupplyManufacturer
            // 
            this.colSupplyManufacturer.Text = "Manufacturer";
            this.colSupplyManufacturer.Width = 120;
            // 
            // colSupplyExpires
            // 
            this.colSupplyExpires.Text = "Expires";
            this.colSupplyExpires.Width = 80;
            // 
            // pageEquipment
            // 
            this.pageEquipment.Controls.Add(this.btnAddEquipment);
            this.pageEquipment.Controls.Add(this.lvEquipment);
            this.pageEquipment.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.pageEquipment.Location = new System.Drawing.Point(4, 21);
            this.pageEquipment.Name = "pageEquipment";
            this.pageEquipment.Size = new System.Drawing.Size(548, 67);
            this.pageEquipment.TabIndex = 1;
            this.pageEquipment.Text = "Equipment";
            this.pageEquipment.Visible = false;
            // 
            // btnAddEquipment
            // 
            this.btnAddEquipment.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnAddEquipment.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.btnAddEquipment.Location = new System.Drawing.Point(452, 4);
            this.btnAddEquipment.Name = "btnAddEquipment";
            this.btnAddEquipment.Size = new System.Drawing.Size(96, 23);
            this.btnAddEquipment.TabIndex = 44;
            this.btnAddEquipment.Text = "Add &Equipment";
            this.btnAddEquipment.Click += new System.EventHandler(this.btnAddEquipment_Click);
            this.btnAddEquipment.Leave += new System.EventHandler(this.btnAddEquipment_Leave);
            // 
            // lvEquipment
            // 
            this.lvEquipment.AccessibleDescription = "Equipment";
            this.lvEquipment.AccessibleName = "Equipment";
            this.lvEquipment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvEquipment.CheckBoxes = true;
            this.lvEquipment.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.colEquipmentCheckbox,
            this.colSerialNumber,
            this.colEquipmentName,
            this.colEquipmentManufacturer,
            this.colLocalID});
            this.lvEquipment.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lvEquipment.FullRowSelect = true;
            this.lvEquipment.Location = new System.Drawing.Point(0, 0);
            this.lvEquipment.MultiSelect = false;
            this.lvEquipment.Name = "lvEquipment";
            this.lvEquipment.Size = new System.Drawing.Size(452, 66);
            this.lvEquipment.TabIndex = 43;
            this.lvEquipment.UseCompatibleStateImageBehavior = false;
            this.lvEquipment.View = System.Windows.Forms.View.Details;
            this.lvEquipment.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvEquipment_ItemCheck);
            this.lvEquipment.Leave += new System.EventHandler(this.lvEquipment_Leave);
            // 
            // colEquipmentCheckbox
            // 
            this.colEquipmentCheckbox.Text = "";
            this.colEquipmentCheckbox.Width = 20;
            // 
            // colSerialNumber
            // 
            this.colSerialNumber.Text = "ID Number";
            this.colSerialNumber.Width = 70;
            // 
            // colEquipmentName
            // 
            this.colEquipmentName.Text = "Equipment Name";
            this.colEquipmentName.Width = 150;
            // 
            // colEquipmentManufacturer
            // 
            this.colEquipmentManufacturer.Text = "Manufacturer";
            this.colEquipmentManufacturer.Width = 120;
            // 
            // colLocalID
            // 
            this.colLocalID.Text = "Local ID";
            this.colLocalID.Width = 80;
            // 
            // pageSCDWafer
            // 
            this.pageSCDWafer.Controls.Add(this.btnAddWafer);
            this.pageSCDWafer.Controls.Add(this.lvSCDWafer);
            this.pageSCDWafer.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.pageSCDWafer.Location = new System.Drawing.Point(4, 21);
            this.pageSCDWafer.Name = "pageSCDWafer";
            this.pageSCDWafer.Size = new System.Drawing.Size(548, 67);
            this.pageSCDWafer.TabIndex = 3;
            this.pageSCDWafer.Text = "SCD Wafer";
            this.pageSCDWafer.Visible = false;
            // 
            // btnAddWafer
            // 
            this.btnAddWafer.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnAddWafer.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.btnAddWafer.Location = new System.Drawing.Point(456, 4);
            this.btnAddWafer.Name = "btnAddWafer";
            this.btnAddWafer.Size = new System.Drawing.Size(92, 23);
            this.btnAddWafer.TabIndex = 46;
            this.btnAddWafer.Text = "Add &Wafer";
            this.btnAddWafer.Click += new System.EventHandler(this.btnAddWafer_Click);
            this.btnAddWafer.Leave += new System.EventHandler(this.btnAddWafer_Leave);
            // 
            // lvSCDWafer
            // 
            this.lvSCDWafer.AccessibleDescription = "S C D Wafer";
            this.lvSCDWafer.AccessibleName = "S C D Wafer";
            this.lvSCDWafer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvSCDWafer.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader5,
            this.columnHeader6,
            this.columnHeader7,
            this.columnHeader8});
            this.lvSCDWafer.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lvSCDWafer.FullRowSelect = true;
            this.lvSCDWafer.Location = new System.Drawing.Point(0, 0);
            this.lvSCDWafer.MultiSelect = false;
            this.lvSCDWafer.Name = "lvSCDWafer";
            this.lvSCDWafer.Size = new System.Drawing.Size(452, 56);
            this.lvSCDWafer.TabIndex = 45;
            this.lvSCDWafer.UseCompatibleStateImageBehavior = false;
            this.lvSCDWafer.View = System.Windows.Forms.View.Details;
            this.lvSCDWafer.Leave += new System.EventHandler(this.lvSCDWafer_Leave);
            // 
            // columnHeader5
            // 
            this.columnHeader5.Text = "Lot Number";
            this.columnHeader5.Width = 70;
            // 
            // columnHeader6
            // 
            this.columnHeader6.Text = "Supply Type";
            this.columnHeader6.Width = 150;
            // 
            // columnHeader7
            // 
            this.columnHeader7.Text = "Manufacturer";
            this.columnHeader7.Width = 120;
            // 
            // columnHeader8
            // 
            this.columnHeader8.Text = "Expires";
            this.columnHeader8.Width = 80;
            // 
            // pnlTargetUnitTop
            // 
            this.pnlTargetUnitTop.Controls.Add(this.pnlTargetExtraInfo);
            this.pnlTargetUnitTop.Controls.Add(this.pnlTargetUnitInfo);
            this.pnlTargetUnitTop.Dock = System.Windows.Forms.DockStyle.Top;
            this.pnlTargetUnitTop.Location = new System.Drawing.Point(0, 0);
            this.pnlTargetUnitTop.Name = "pnlTargetUnitTop";
            this.pnlTargetUnitTop.Size = new System.Drawing.Size(556, 124);
            this.pnlTargetUnitTop.TabIndex = 132;
            // 
            // pnlTargetExtraInfo
            // 
            this.pnlTargetExtraInfo.Controls.Add(this.tabTargetExtraInfo);
            this.pnlTargetExtraInfo.Controls.Add(this.txtTargetDonationType);
            this.pnlTargetExtraInfo.Controls.Add(this.lblTargetDonationType);
            this.pnlTargetExtraInfo.Dock = System.Windows.Forms.DockStyle.Fill;
            this.pnlTargetExtraInfo.Location = new System.Drawing.Point(298, 0);
            this.pnlTargetExtraInfo.Name = "pnlTargetExtraInfo";
            this.pnlTargetExtraInfo.Size = new System.Drawing.Size(258, 124);
            this.pnlTargetExtraInfo.TabIndex = 1;
            // 
            // tabTargetExtraInfo
            // 
            this.tabTargetExtraInfo.Alignment = System.Windows.Forms.TabAlignment.Bottom;
            this.tabTargetExtraInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.tabTargetExtraInfo.Controls.Add(this.pageTargetRestricted);
            this.tabTargetExtraInfo.Controls.Add(this.pageTargetAssigned);
            this.tabTargetExtraInfo.Controls.Add(this.pageTargetSpecialTesting);
            this.tabTargetExtraInfo.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.tabTargetExtraInfo.Location = new System.Drawing.Point(4, 24);
            this.tabTargetExtraInfo.Multiline = true;
            this.tabTargetExtraInfo.Name = "tabTargetExtraInfo";
            this.tabTargetExtraInfo.SelectedIndex = 0;
            this.tabTargetExtraInfo.Size = new System.Drawing.Size(250, 100);
            this.tabTargetExtraInfo.TabIndex = 30;
            this.tabTargetExtraInfo.SelectedIndexChanged += new System.EventHandler(this.ExtraInfoTabsClicked);
            this.tabTargetExtraInfo.Leave += new System.EventHandler(this.tabTargetExtraInfo_Leave);
            // 
            // pageTargetRestricted
            // 
            this.pageTargetRestricted.Controls.Add(this.picTargetBiohazard);
            this.pageTargetRestricted.Controls.Add(this.txtTargetRestrictedStatus);
            this.pageTargetRestricted.Controls.Add(this.lblTargetTestingStatus);
            this.pageTargetRestricted.Controls.Add(this.txtTargetRestrictedSSN);
            this.pageTargetRestricted.Controls.Add(this.txtTargetRestrictedName);
            this.pageTargetRestricted.Controls.Add(this.lblTargetRestrictedSSN);
            this.pageTargetRestricted.Controls.Add(this.lblTargetRestrictedName);
            this.pageTargetRestricted.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.pageTargetRestricted.Location = new System.Drawing.Point(4, 4);
            this.pageTargetRestricted.Name = "pageTargetRestricted";
            this.pageTargetRestricted.Size = new System.Drawing.Size(242, 75);
            this.pageTargetRestricted.TabIndex = 0;
            this.pageTargetRestricted.Text = "Restricted For";
            // 
            // picTargetBiohazard
            // 
            this.picTargetBiohazard.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.picTargetBiohazard.Image = ((System.Drawing.Image)(resources.GetObject("picTargetBiohazard.Image")));
            this.picTargetBiohazard.Location = new System.Drawing.Point(214, 40);
            this.picTargetBiohazard.Name = "picTargetBiohazard";
            this.picTargetBiohazard.Size = new System.Drawing.Size(26, 28);
            this.picTargetBiohazard.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.picTargetBiohazard.TabIndex = 35;
            this.picTargetBiohazard.TabStop = false;
            this.picTargetBiohazard.Visible = false;
            // 
            // txtTargetRestrictedStatus
            // 
            this.txtTargetRestrictedStatus.AccessibleDescription = "Disease Marker Testing";
            this.txtTargetRestrictedStatus.AccessibleName = "Disease Marker Testing";
            this.txtTargetRestrictedStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtTargetRestrictedStatus.Location = new System.Drawing.Point(88, 48);
            this.txtTargetRestrictedStatus.Name = "txtTargetRestrictedStatus";
            this.txtTargetRestrictedStatus.ReadOnly = true;
            this.txtTargetRestrictedStatus.Size = new System.Drawing.Size(122, 20);
            this.txtTargetRestrictedStatus.TabIndex = 33;
            this.txtTargetRestrictedStatus.Leave += new System.EventHandler(this.txtTargetRestrictedStatus_Leave);
            // 
            // lblTargetTestingStatus
            // 
            this.lblTargetTestingStatus.Location = new System.Drawing.Point(0, 48);
            this.lblTargetTestingStatus.Name = "lblTargetTestingStatus";
            this.lblTargetTestingStatus.Size = new System.Drawing.Size(92, 24);
            this.lblTargetTestingStatus.TabIndex = 15;
            this.lblTargetTestingStatus.Text = "Disease Marker Testing";
            this.lblTargetTestingStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtTargetRestrictedSSN
            // 
            this.txtTargetRestrictedSSN.AccessibleDescription = "Patient I D";
            this.txtTargetRestrictedSSN.AccessibleName = "Patient I D";
            this.txtTargetRestrictedSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtTargetRestrictedSSN.Location = new System.Drawing.Point(88, 24);
            this.txtTargetRestrictedSSN.Name = "txtTargetRestrictedSSN";
            this.txtTargetRestrictedSSN.ReadOnly = true;
            this.txtTargetRestrictedSSN.Size = new System.Drawing.Size(122, 20);
            this.txtTargetRestrictedSSN.TabIndex = 32;
            this.txtTargetRestrictedSSN.Leave += new System.EventHandler(this.txtTargetRestrictedSSN_Leave);
            // 
            // txtTargetRestrictedName
            // 
            this.txtTargetRestrictedName.AccessibleDescription = "Patient Name";
            this.txtTargetRestrictedName.AccessibleName = "Patient Name";
            this.txtTargetRestrictedName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtTargetRestrictedName.Location = new System.Drawing.Point(88, 0);
            this.txtTargetRestrictedName.Name = "txtTargetRestrictedName";
            this.txtTargetRestrictedName.ReadOnly = true;
            this.txtTargetRestrictedName.Size = new System.Drawing.Size(154, 20);
            this.txtTargetRestrictedName.TabIndex = 31;
            this.txtTargetRestrictedName.Leave += new System.EventHandler(this.txtTargetRestrictedName_Leave);
            // 
            // lblTargetRestrictedSSN
            // 
            this.lblTargetRestrictedSSN.Location = new System.Drawing.Point(0, 24);
            this.lblTargetRestrictedSSN.Name = "lblTargetRestrictedSSN";
            this.lblTargetRestrictedSSN.Size = new System.Drawing.Size(92, 20);
            this.lblTargetRestrictedSSN.TabIndex = 12;
            this.lblTargetRestrictedSSN.Text = "Patient ID";
            this.lblTargetRestrictedSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblTargetRestrictedName
            // 
            this.lblTargetRestrictedName.Location = new System.Drawing.Point(0, 0);
            this.lblTargetRestrictedName.Name = "lblTargetRestrictedName";
            this.lblTargetRestrictedName.Size = new System.Drawing.Size(92, 20);
            this.lblTargetRestrictedName.TabIndex = 11;
            this.lblTargetRestrictedName.Text = "Patient Name";
            this.lblTargetRestrictedName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pageTargetAssigned
            // 
            this.pageTargetAssigned.Controls.Add(this.lvTargetAssigned);
            this.pageTargetAssigned.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.pageTargetAssigned.Location = new System.Drawing.Point(4, 4);
            this.pageTargetAssigned.Name = "pageTargetAssigned";
            this.pageTargetAssigned.Size = new System.Drawing.Size(242, 75);
            this.pageTargetAssigned.TabIndex = 1;
            this.pageTargetAssigned.Text = "Assigned To";
            this.pageTargetAssigned.Visible = false;
            // 
            // lvTargetAssigned
            // 
            this.lvTargetAssigned.AccessibleDescription = "Assigned To ";
            this.lvTargetAssigned.AccessibleName = "Assigned To ";
            this.lvTargetAssigned.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvTargetAssigned.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader9,
            this.columnHeader10,
            this.columnHeader11,
            this.columnHeader12});
            this.lvTargetAssigned.Location = new System.Drawing.Point(0, 0);
            this.lvTargetAssigned.Name = "lvTargetAssigned";
            this.lvTargetAssigned.Size = new System.Drawing.Size(242, 72);
            this.lvTargetAssigned.TabIndex = 34;
            this.lvTargetAssigned.UseCompatibleStateImageBehavior = false;
            this.lvTargetAssigned.View = System.Windows.Forms.View.Details;
            this.lvTargetAssigned.Leave += new System.EventHandler(this.lvTargetAssigned_Leave);
            // 
            // columnHeader9
            // 
            this.columnHeader9.Text = "Patient Name";
            this.columnHeader9.Width = 80;
            // 
            // columnHeader10
            // 
            this.columnHeader10.Text = "Patient ID";
            // 
            // columnHeader11
            // 
            this.columnHeader11.Text = "Specimen UID";
            this.columnHeader11.Width = 80;
            // 
            // columnHeader12
            // 
            this.columnHeader12.Text = "Specimen Expires";
            this.columnHeader12.Width = 100;
            // 
            // pageTargetSpecialTesting
            // 
            this.pageTargetSpecialTesting.Controls.Add(this.lblTargetSickleCellNeg);
            this.pageTargetSpecialTesting.Controls.Add(this.lblTargetCMVNeg);
            this.pageTargetSpecialTesting.Controls.Add(this.lvTargetAntigens);
            this.pageTargetSpecialTesting.Controls.Add(this.lblTargetRBCAntigens);
            this.pageTargetSpecialTesting.Controls.Add(this.cbTargetSickleCellNeg);
            this.pageTargetSpecialTesting.Controls.Add(this.cbTargetCMVNeg);
            this.pageTargetSpecialTesting.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.pageTargetSpecialTesting.Location = new System.Drawing.Point(4, 4);
            this.pageTargetSpecialTesting.Name = "pageTargetSpecialTesting";
            this.pageTargetSpecialTesting.Size = new System.Drawing.Size(242, 75);
            this.pageTargetSpecialTesting.TabIndex = 2;
            this.pageTargetSpecialTesting.Text = "Special Testing";
            this.pageTargetSpecialTesting.Visible = false;
            // 
            // lblTargetSickleCellNeg
            // 
            this.lblTargetSickleCellNeg.Location = new System.Drawing.Point(0, 40);
            this.lblTargetSickleCellNeg.Name = "lblTargetSickleCellNeg";
            this.lblTargetSickleCellNeg.Size = new System.Drawing.Size(92, 20);
            this.lblTargetSickleCellNeg.TabIndex = 19;
            this.lblTargetSickleCellNeg.Text = "Sic&kle Cell Neg?";
            this.lblTargetSickleCellNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblTargetCMVNeg
            // 
            this.lblTargetCMVNeg.Location = new System.Drawing.Point(0, 16);
            this.lblTargetCMVNeg.Name = "lblTargetCMVNeg";
            this.lblTargetCMVNeg.Size = new System.Drawing.Size(92, 20);
            this.lblTargetCMVNeg.TabIndex = 18;
            this.lblTargetCMVNeg.Text = "CM&V Neg?";
            this.lblTargetCMVNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lvTargetAntigens
            // 
            this.lvTargetAntigens.AccessibleDescription = "R B C Antigens";
            this.lvTargetAntigens.AccessibleName = "R B C Antigens";
            this.lvTargetAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvTargetAntigens.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.colTargetAntigens,
            this.colTargetPosNeg});
            this.lvTargetAntigens.FullRowSelect = true;
            this.lvTargetAntigens.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
            this.lvTargetAntigens.Location = new System.Drawing.Point(124, 16);
            this.lvTargetAntigens.MultiSelect = false;
            this.lvTargetAntigens.Name = "lvTargetAntigens";
            this.lvTargetAntigens.Size = new System.Drawing.Size(118, 56);
            this.lvTargetAntigens.TabIndex = 37;
            this.lvTargetAntigens.UseCompatibleStateImageBehavior = false;
            this.lvTargetAntigens.View = System.Windows.Forms.View.Details;
            this.lvTargetAntigens.Leave += new System.EventHandler(this.lvTargetAntigens_Leave);
            // 
            // colTargetAntigens
            // 
            this.colTargetAntigens.Text = "";
            this.colTargetAntigens.Width = 5;
            // 
            // colTargetPosNeg
            // 
            this.colTargetPosNeg.Text = "";
            this.colTargetPosNeg.Width = 5;
            // 
            // lblTargetRBCAntigens
            // 
            this.lblTargetRBCAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblTargetRBCAntigens.Location = new System.Drawing.Point(124, 0);
            this.lblTargetRBCAntigens.Name = "lblTargetRBCAntigens";
            this.lblTargetRBCAntigens.Size = new System.Drawing.Size(94, 16);
            this.lblTargetRBCAntigens.TabIndex = 2;
            this.lblTargetRBCAntigens.Text = "RBC Antigens";
            this.lblTargetRBCAntigens.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // cbTargetSickleCellNeg
            // 
            this.cbTargetSickleCellNeg.AccessibleDescription = "Sickle Cell Negative ";
            this.cbTargetSickleCellNeg.AccessibleName = "Sickle Cell Negative ";
            this.cbTargetSickleCellNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.cbTargetSickleCellNeg.Enabled = false;
            this.cbTargetSickleCellNeg.Location = new System.Drawing.Point(0, 40);
            this.cbTargetSickleCellNeg.Name = "cbTargetSickleCellNeg";
            this.cbTargetSickleCellNeg.Size = new System.Drawing.Size(112, 20);
            this.cbTargetSickleCellNeg.TabIndex = 36;
            this.cbTargetSickleCellNeg.TabStop = false;
            this.cbTargetSickleCellNeg.Text = "Sic&kle Cell Neg";
            this.cbTargetSickleCellNeg.Leave += new System.EventHandler(this.cbTargetSickleCellNeg_Leave);
            // 
            // cbTargetCMVNeg
            // 
            this.cbTargetCMVNeg.AccessibleDescription = "C M V Negative";
            this.cbTargetCMVNeg.AccessibleName = "C M V Negative";
            this.cbTargetCMVNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.cbTargetCMVNeg.Enabled = false;
            this.cbTargetCMVNeg.Location = new System.Drawing.Point(0, 16);
            this.cbTargetCMVNeg.Name = "cbTargetCMVNeg";
            this.cbTargetCMVNeg.Size = new System.Drawing.Size(112, 20);
            this.cbTargetCMVNeg.TabIndex = 35;
            this.cbTargetCMVNeg.TabStop = false;
            this.cbTargetCMVNeg.Text = "CM&V Neg";
            this.cbTargetCMVNeg.Leave += new System.EventHandler(this.cbTargetCMVNeg_Leave);
            // 
            // txtTargetDonationType
            // 
            this.txtTargetDonationType.AccessibleDescription = "Donation Type";
            this.txtTargetDonationType.AccessibleName = "Donation Type";
            this.txtTargetDonationType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtTargetDonationType.Location = new System.Drawing.Point(96, 4);
            this.txtTargetDonationType.Name = "txtTargetDonationType";
            this.txtTargetDonationType.ReadOnly = true;
            this.txtTargetDonationType.Size = new System.Drawing.Size(154, 20);
            this.txtTargetDonationType.TabIndex = 29;
            this.txtTargetDonationType.Leave += new System.EventHandler(this.txtTargetDonationType_Leave);
            // 
            // lblTargetDonationType
            // 
            this.lblTargetDonationType.Location = new System.Drawing.Point(8, 4);
            this.lblTargetDonationType.Name = "lblTargetDonationType";
            this.lblTargetDonationType.Size = new System.Drawing.Size(92, 20);
            this.lblTargetDonationType.TabIndex = 127;
            this.lblTargetDonationType.Text = "Donation Type";
            this.lblTargetDonationType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pnlTargetUnitInfo
            // 
            this.pnlTargetUnitInfo.Controls.Add(this.cmbTargetProductName);
            this.pnlTargetUnitInfo.Controls.Add(this.txtTargetUnitStatus);
            this.pnlTargetUnitInfo.Controls.Add(this.lblTargetUnitStatus);
            this.pnlTargetUnitInfo.Controls.Add(this.updTargetVolume);
            this.pnlTargetUnitInfo.Controls.Add(this.txtTargetABORh);
            this.pnlTargetUnitInfo.Controls.Add(this.txtTargetUnitId);
            this.pnlTargetUnitInfo.Controls.Add(this.dtpTargetExpirationDate);
            this.pnlTargetUnitInfo.Controls.Add(this.lblTargetVolume);
            this.pnlTargetUnitInfo.Controls.Add(this.lblTargetProductName);
            this.pnlTargetUnitInfo.Controls.Add(this.lblTargetExpirationDate);
            this.pnlTargetUnitInfo.Controls.Add(this.lblTargetABORh);
            this.pnlTargetUnitInfo.Controls.Add(this.lblTargetUnitId);
            this.pnlTargetUnitInfo.Dock = System.Windows.Forms.DockStyle.Left;
            this.pnlTargetUnitInfo.Location = new System.Drawing.Point(0, 0);
            this.pnlTargetUnitInfo.Name = "pnlTargetUnitInfo";
            this.pnlTargetUnitInfo.Size = new System.Drawing.Size(298, 124);
            this.pnlTargetUnitInfo.TabIndex = 0;
            // 
            // cmbTargetProductName
            // 
            this.cmbTargetProductName.AccessibleDescription = "Product";
            this.cmbTargetProductName.AccessibleName = "Product";
            this.cmbTargetProductName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbTargetProductName.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cmbTargetProductName.Location = new System.Drawing.Point(88, 26);
            this.cmbTargetProductName.Name = "cmbTargetProductName";
            this.cmbTargetProductName.Size = new System.Drawing.Size(200, 22);
            this.cmbTargetProductName.TabIndex = 24;
            this.cmbTargetProductName.SelectedIndexChanged += new System.EventHandler(this.cmbTargetProductName_SelectedIndexChanged);
            this.cmbTargetProductName.Leave += new System.EventHandler(this.cmbTargetProductName_Leave);
            // 
            // txtTargetUnitStatus
            // 
            this.txtTargetUnitStatus.AccessibleDescription = "Unit Status";
            this.txtTargetUnitStatus.AccessibleName = "Unit Status";
            this.txtTargetUnitStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtTargetUnitStatus.Location = new System.Drawing.Point(88, 100);
            this.txtTargetUnitStatus.Name = "txtTargetUnitStatus";
            this.txtTargetUnitStatus.ReadOnly = true;
            this.txtTargetUnitStatus.Size = new System.Drawing.Size(200, 20);
            this.txtTargetUnitStatus.TabIndex = 28;
            this.txtTargetUnitStatus.Leave += new System.EventHandler(this.txtTargetUnitStatus_Leave);
            // 
            // lblTargetUnitStatus
            // 
            this.lblTargetUnitStatus.Location = new System.Drawing.Point(4, 100);
            this.lblTargetUnitStatus.Name = "lblTargetUnitStatus";
            this.lblTargetUnitStatus.Size = new System.Drawing.Size(88, 20);
            this.lblTargetUnitStatus.TabIndex = 131;
            this.lblTargetUnitStatus.Text = "Unit Status";
            this.lblTargetUnitStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // updTargetVolume
            // 
            this.updTargetVolume.AccessibleDescription = "Volume Milliliters";
            this.updTargetVolume.AccessibleName = "Volume Milliliters";
            this.updTargetVolume.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.updTargetVolume.Location = new System.Drawing.Point(240, 52);
            this.updTargetVolume.Maximum = new decimal(new int[] {
            2000,
            0,
            0,
            0});
            this.updTargetVolume.Name = "updTargetVolume";
            this.updTargetVolume.Size = new System.Drawing.Size(48, 20);
            this.updTargetVolume.TabIndex = 26;
            this.updTargetVolume.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.updTargetVolume.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.updTargetVolume.TextChanged += new System.EventHandler(this.updTargetVolume_ValueChanged);
            this.updTargetVolume.ValueChanged += new System.EventHandler(this.updTargetVolume_ValueChanged);
            this.updTargetVolume.Leave += new System.EventHandler(this.updTargetVolume_Leave);
            // 
            // txtTargetABORh
            // 
            this.txtTargetABORh.AccessibleDescription = "A B O R H";
            this.txtTargetABORh.AccessibleName = "A B O R H";
            this.txtTargetABORh.Location = new System.Drawing.Point(88, 52);
            this.txtTargetABORh.Name = "txtTargetABORh";
            this.txtTargetABORh.ReadOnly = true;
            this.txtTargetABORh.Size = new System.Drawing.Size(80, 20);
            this.txtTargetABORh.TabIndex = 25;
            this.txtTargetABORh.Leave += new System.EventHandler(this.txtTargetABORh_Leave);
            // 
            // txtTargetUnitId
            // 
            this.txtTargetUnitId.AccessibleDescription = "Unit I D";
            this.txtTargetUnitId.AccessibleName = "Unit I D";
            this.txtTargetUnitId.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtTargetUnitId.Location = new System.Drawing.Point(88, 4);
            this.txtTargetUnitId.Name = "txtTargetUnitId";
            this.txtTargetUnitId.ReadOnly = true;
            this.txtTargetUnitId.Size = new System.Drawing.Size(200, 20);
            this.txtTargetUnitId.TabIndex = 23;
            this.txtTargetUnitId.Leave += new System.EventHandler(this.txtTargetUnitId_Leave);
            // 
            // dtpTargetExpirationDate
            // 
            this.dtpTargetExpirationDate.AccessibleDescription = "Expiration Date";
            this.dtpTargetExpirationDate.AccessibleName = "Expiration Date";
            this.dtpTargetExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.dtpTargetExpirationDate.CustomFormat = "";
            this.dtpTargetExpirationDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpTargetExpirationDate.Location = new System.Drawing.Point(88, 76);
            this.dtpTargetExpirationDate.Name = "dtpTargetExpirationDate";
            this.dtpTargetExpirationDate.Size = new System.Drawing.Size(200, 20);
            this.dtpTargetExpirationDate.TabIndex = 27;
            this.dtpTargetExpirationDate.Leave += new System.EventHandler(this.dtpTargetExpirationDate_Leave);
            this.dtpTargetExpirationDate.MouseUp += new System.Windows.Forms.MouseEventHandler(this.dtpTargetExpirationDate_MouseUp);
            // 
            // lblTargetVolume
            // 
            this.lblTargetVolume.Location = new System.Drawing.Point(176, 52);
            this.lblTargetVolume.Name = "lblTargetVolume";
            this.lblTargetVolume.Size = new System.Drawing.Size(68, 20);
            this.lblTargetVolume.TabIndex = 129;
            this.lblTargetVolume.Text = "Volume (ml)";
            this.lblTargetVolume.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblTargetProductName
            // 
            this.lblTargetProductName.Location = new System.Drawing.Point(4, 28);
            this.lblTargetProductName.Name = "lblTargetProductName";
            this.lblTargetProductName.Size = new System.Drawing.Size(96, 20);
            this.lblTargetProductName.TabIndex = 128;
            this.lblTargetProductName.Text = "Product*";
            this.lblTargetProductName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblTargetExpirationDate
            // 
            this.lblTargetExpirationDate.Location = new System.Drawing.Point(4, 76);
            this.lblTargetExpirationDate.Name = "lblTargetExpirationDate";
            this.lblTargetExpirationDate.Size = new System.Drawing.Size(92, 20);
            this.lblTargetExpirationDate.TabIndex = 126;
            this.lblTargetExpirationDate.Text = "Expiration Date*";
            this.lblTargetExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblTargetABORh
            // 
            this.lblTargetABORh.Location = new System.Drawing.Point(4, 52);
            this.lblTargetABORh.Name = "lblTargetABORh";
            this.lblTargetABORh.Size = new System.Drawing.Size(92, 20);
            this.lblTargetABORh.TabIndex = 125;
            this.lblTargetABORh.Text = "ABO/Rh";
            this.lblTargetABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblTargetUnitId
            // 
            this.lblTargetUnitId.Location = new System.Drawing.Point(4, 4);
            this.lblTargetUnitId.Name = "lblTargetUnitId";
            this.lblTargetUnitId.Size = new System.Drawing.Size(92, 20);
            this.lblTargetUnitId.TabIndex = 124;
            this.lblTargetUnitId.Text = "Unit ID";
            this.lblTargetUnitId.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pnlOriginalUnit
            // 
            this.pnlOriginalUnit.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlOriginalUnit.Controls.Add(this.pnlOriginalExtraInfo);
            this.pnlOriginalUnit.Controls.Add(this.pnlOriginalUnitInfo);
            this.pnlOriginalUnit.Location = new System.Drawing.Point(60, 88);
            this.pnlOriginalUnit.Name = "pnlOriginalUnit";
            this.pnlOriginalUnit.Size = new System.Drawing.Size(560, 124);
            this.pnlOriginalUnit.TabIndex = 48;
            // 
            // pnlOriginalExtraInfo
            // 
            this.pnlOriginalExtraInfo.Controls.Add(this.tabOriginalExtraInfo);
            this.pnlOriginalExtraInfo.Controls.Add(this.txtOriginalDonationType);
            this.pnlOriginalExtraInfo.Controls.Add(this.lblOriginalDonationType);
            this.pnlOriginalExtraInfo.Dock = System.Windows.Forms.DockStyle.Fill;
            this.pnlOriginalExtraInfo.Location = new System.Drawing.Point(298, 0);
            this.pnlOriginalExtraInfo.Name = "pnlOriginalExtraInfo";
            this.pnlOriginalExtraInfo.Size = new System.Drawing.Size(262, 124);
            this.pnlOriginalExtraInfo.TabIndex = 2;
            // 
            // tabOriginalExtraInfo
            // 
            this.tabOriginalExtraInfo.Alignment = System.Windows.Forms.TabAlignment.Bottom;
            this.tabOriginalExtraInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.tabOriginalExtraInfo.Controls.Add(this.pageOriginalRestricted);
            this.tabOriginalExtraInfo.Controls.Add(this.pageOriginalAssigned);
            this.tabOriginalExtraInfo.Controls.Add(this.pageOriginalSpecialTesting);
            this.tabOriginalExtraInfo.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.tabOriginalExtraInfo.Location = new System.Drawing.Point(4, 24);
            this.tabOriginalExtraInfo.Name = "tabOriginalExtraInfo";
            this.tabOriginalExtraInfo.SelectedIndex = 0;
            this.tabOriginalExtraInfo.Size = new System.Drawing.Size(254, 96);
            this.tabOriginalExtraInfo.TabIndex = 11;
            this.tabOriginalExtraInfo.SelectedIndexChanged += new System.EventHandler(this.ExtraInfoTabsClicked);
            this.tabOriginalExtraInfo.Leave += new System.EventHandler(this.tabOriginalExtraInfo_Leave);
            // 
            // pageOriginalRestricted
            // 
            this.pageOriginalRestricted.Controls.Add(this.picOriginalBiohazard);
            this.pageOriginalRestricted.Controls.Add(this.txtOriginalRestrictedStatus);
            this.pageOriginalRestricted.Controls.Add(this.lblOriginalRestrictedStatus);
            this.pageOriginalRestricted.Controls.Add(this.txtOriginalRestrictedSSN);
            this.pageOriginalRestricted.Controls.Add(this.txtOriginalRestrictedName);
            this.pageOriginalRestricted.Controls.Add(this.lblOriginalRestrictedSSN);
            this.pageOriginalRestricted.Controls.Add(this.lblOriginalRestrictedName);
            this.pageOriginalRestricted.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.pageOriginalRestricted.Location = new System.Drawing.Point(4, 4);
            this.pageOriginalRestricted.Name = "pageOriginalRestricted";
            this.pageOriginalRestricted.Size = new System.Drawing.Size(246, 71);
            this.pageOriginalRestricted.TabIndex = 0;
            this.pageOriginalRestricted.Text = "Restricted For";
            // 
            // picOriginalBiohazard
            // 
            this.picOriginalBiohazard.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.picOriginalBiohazard.Image = ((System.Drawing.Image)(resources.GetObject("picOriginalBiohazard.Image")));
            this.picOriginalBiohazard.Location = new System.Drawing.Point(218, 40);
            this.picOriginalBiohazard.Name = "picOriginalBiohazard";
            this.picOriginalBiohazard.Size = new System.Drawing.Size(26, 28);
            this.picOriginalBiohazard.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.picOriginalBiohazard.TabIndex = 34;
            this.picOriginalBiohazard.TabStop = false;
            this.picOriginalBiohazard.Visible = false;
            // 
            // txtOriginalRestrictedStatus
            // 
            this.txtOriginalRestrictedStatus.AccessibleDescription = "Disease Marker Testing";
            this.txtOriginalRestrictedStatus.AccessibleName = "Disease Marker Testing";
            this.txtOriginalRestrictedStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtOriginalRestrictedStatus.Location = new System.Drawing.Point(88, 48);
            this.txtOriginalRestrictedStatus.Name = "txtOriginalRestrictedStatus";
            this.txtOriginalRestrictedStatus.ReadOnly = true;
            this.txtOriginalRestrictedStatus.Size = new System.Drawing.Size(126, 20);
            this.txtOriginalRestrictedStatus.TabIndex = 14;
            this.txtOriginalRestrictedStatus.Leave += new System.EventHandler(this.txtOriginalRestrictedStatus_Leave);
            // 
            // lblOriginalRestrictedStatus
            // 
            this.lblOriginalRestrictedStatus.Location = new System.Drawing.Point(0, 48);
            this.lblOriginalRestrictedStatus.Name = "lblOriginalRestrictedStatus";
            this.lblOriginalRestrictedStatus.Size = new System.Drawing.Size(92, 24);
            this.lblOriginalRestrictedStatus.TabIndex = 15;
            this.lblOriginalRestrictedStatus.Text = "Disease Marker Testing";
            this.lblOriginalRestrictedStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtOriginalRestrictedSSN
            // 
            this.txtOriginalRestrictedSSN.AccessibleDescription = "Patient I D";
            this.txtOriginalRestrictedSSN.AccessibleName = "Patient I D";
            this.txtOriginalRestrictedSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtOriginalRestrictedSSN.Location = new System.Drawing.Point(88, 24);
            this.txtOriginalRestrictedSSN.Name = "txtOriginalRestrictedSSN";
            this.txtOriginalRestrictedSSN.ReadOnly = true;
            this.txtOriginalRestrictedSSN.Size = new System.Drawing.Size(126, 20);
            this.txtOriginalRestrictedSSN.TabIndex = 13;
            this.txtOriginalRestrictedSSN.Leave += new System.EventHandler(this.txtOriginalRestrictedSSN_Leave);
            // 
            // txtOriginalRestrictedName
            // 
            this.txtOriginalRestrictedName.AccessibleDescription = "Patient Name";
            this.txtOriginalRestrictedName.AccessibleName = "Patient Name";
            this.txtOriginalRestrictedName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtOriginalRestrictedName.Location = new System.Drawing.Point(88, 0);
            this.txtOriginalRestrictedName.Name = "txtOriginalRestrictedName";
            this.txtOriginalRestrictedName.ReadOnly = true;
            this.txtOriginalRestrictedName.Size = new System.Drawing.Size(158, 20);
            this.txtOriginalRestrictedName.TabIndex = 12;
            this.txtOriginalRestrictedName.Leave += new System.EventHandler(this.txtOriginalRestrictedName_Leave);
            // 
            // lblOriginalRestrictedSSN
            // 
            this.lblOriginalRestrictedSSN.Location = new System.Drawing.Point(0, 24);
            this.lblOriginalRestrictedSSN.Name = "lblOriginalRestrictedSSN";
            this.lblOriginalRestrictedSSN.Size = new System.Drawing.Size(92, 20);
            this.lblOriginalRestrictedSSN.TabIndex = 12;
            this.lblOriginalRestrictedSSN.Text = "Patient ID";
            this.lblOriginalRestrictedSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblOriginalRestrictedName
            // 
            this.lblOriginalRestrictedName.Location = new System.Drawing.Point(0, 0);
            this.lblOriginalRestrictedName.Name = "lblOriginalRestrictedName";
            this.lblOriginalRestrictedName.Size = new System.Drawing.Size(92, 20);
            this.lblOriginalRestrictedName.TabIndex = 11;
            this.lblOriginalRestrictedName.Text = "Patient Name";
            this.lblOriginalRestrictedName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pageOriginalAssigned
            // 
            this.pageOriginalAssigned.Controls.Add(this.lvOriginalAssigned);
            this.pageOriginalAssigned.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.pageOriginalAssigned.Location = new System.Drawing.Point(4, 4);
            this.pageOriginalAssigned.Name = "pageOriginalAssigned";
            this.pageOriginalAssigned.Size = new System.Drawing.Size(246, 71);
            this.pageOriginalAssigned.TabIndex = 1;
            this.pageOriginalAssigned.Text = "Assigned To";
            this.pageOriginalAssigned.Visible = false;
            // 
            // lvOriginalAssigned
            // 
            this.lvOriginalAssigned.AccessibleDescription = "Assigned To";
            this.lvOriginalAssigned.AccessibleName = "Assigned To";
            this.lvOriginalAssigned.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvOriginalAssigned.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader13,
            this.columnHeader14,
            this.columnHeader15,
            this.columnHeader16});
            this.lvOriginalAssigned.Location = new System.Drawing.Point(0, 0);
            this.lvOriginalAssigned.Name = "lvOriginalAssigned";
            this.lvOriginalAssigned.Size = new System.Drawing.Size(246, 70);
            this.lvOriginalAssigned.TabIndex = 15;
            this.lvOriginalAssigned.UseCompatibleStateImageBehavior = false;
            this.lvOriginalAssigned.View = System.Windows.Forms.View.Details;
            this.lvOriginalAssigned.Leave += new System.EventHandler(this.lvOriginalAssigned_Leave);
            // 
            // columnHeader13
            // 
            this.columnHeader13.Text = "Patient Name";
            this.columnHeader13.Width = 80;
            // 
            // columnHeader14
            // 
            this.columnHeader14.Text = "Patient ID";
            // 
            // columnHeader15
            // 
            this.columnHeader15.Text = "Specimen UID";
            this.columnHeader15.Width = 80;
            // 
            // columnHeader16
            // 
            this.columnHeader16.Text = "Specimen Expires";
            this.columnHeader16.Width = 100;
            // 
            // pageOriginalSpecialTesting
            // 
            this.pageOriginalSpecialTesting.Controls.Add(this.lblOriginalSickleCellNeg);
            this.pageOriginalSpecialTesting.Controls.Add(this.lblOriginalCMVNeg);
            this.pageOriginalSpecialTesting.Controls.Add(this.lvOriginalAntigens);
            this.pageOriginalSpecialTesting.Controls.Add(this.lblOriginalRBCAntigens);
            this.pageOriginalSpecialTesting.Controls.Add(this.cbOriginalSickleCellNeg);
            this.pageOriginalSpecialTesting.Controls.Add(this.cbOriginalCMVNeg);
            this.pageOriginalSpecialTesting.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.pageOriginalSpecialTesting.Location = new System.Drawing.Point(4, 4);
            this.pageOriginalSpecialTesting.Name = "pageOriginalSpecialTesting";
            this.pageOriginalSpecialTesting.Size = new System.Drawing.Size(246, 71);
            this.pageOriginalSpecialTesting.TabIndex = 2;
            this.pageOriginalSpecialTesting.Text = "Special Testing";
            this.pageOriginalSpecialTesting.Visible = false;
            // 
            // lblOriginalSickleCellNeg
            // 
            this.lblOriginalSickleCellNeg.Location = new System.Drawing.Point(0, 40);
            this.lblOriginalSickleCellNeg.Name = "lblOriginalSickleCellNeg";
            this.lblOriginalSickleCellNeg.Size = new System.Drawing.Size(92, 20);
            this.lblOriginalSickleCellNeg.TabIndex = 17;
            this.lblOriginalSickleCellNeg.Text = "Sickle Cell &Neg?";
            this.lblOriginalSickleCellNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblOriginalCMVNeg
            // 
            this.lblOriginalCMVNeg.Location = new System.Drawing.Point(0, 16);
            this.lblOriginalCMVNeg.Name = "lblOriginalCMVNeg";
            this.lblOriginalCMVNeg.Size = new System.Drawing.Size(92, 20);
            this.lblOriginalCMVNeg.TabIndex = 16;
            this.lblOriginalCMVNeg.Text = "C&MV Neg?";
            this.lblOriginalCMVNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lvOriginalAntigens
            // 
            this.lvOriginalAntigens.AccessibleDescription = "R B C Antigens";
            this.lvOriginalAntigens.AccessibleName = "R B C Antigens";
            this.lvOriginalAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvOriginalAntigens.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.colOriginalAntigen,
            this.colOriginalPosNeg});
            this.lvOriginalAntigens.FullRowSelect = true;
            this.lvOriginalAntigens.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
            this.lvOriginalAntigens.Location = new System.Drawing.Point(124, 16);
            this.lvOriginalAntigens.MultiSelect = false;
            this.lvOriginalAntigens.Name = "lvOriginalAntigens";
            this.lvOriginalAntigens.Size = new System.Drawing.Size(122, 52);
            this.lvOriginalAntigens.TabIndex = 18;
            this.lvOriginalAntigens.UseCompatibleStateImageBehavior = false;
            this.lvOriginalAntigens.View = System.Windows.Forms.View.Details;
            this.lvOriginalAntigens.Leave += new System.EventHandler(this.lvOriginalAntigens_Leave);
            // 
            // colOriginalAntigen
            // 
            this.colOriginalAntigen.Text = "";
            this.colOriginalAntigen.Width = 5;
            // 
            // colOriginalPosNeg
            // 
            this.colOriginalPosNeg.Text = "";
            this.colOriginalPosNeg.Width = 5;
            // 
            // lblOriginalRBCAntigens
            // 
            this.lblOriginalRBCAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblOriginalRBCAntigens.Location = new System.Drawing.Point(124, 0);
            this.lblOriginalRBCAntigens.Name = "lblOriginalRBCAntigens";
            this.lblOriginalRBCAntigens.Size = new System.Drawing.Size(102, 16);
            this.lblOriginalRBCAntigens.TabIndex = 10;
            this.lblOriginalRBCAntigens.Text = "RBC Antigens";
            this.lblOriginalRBCAntigens.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // cbOriginalSickleCellNeg
            // 
            this.cbOriginalSickleCellNeg.AccessibleDescription = "Sickle Cell Negative";
            this.cbOriginalSickleCellNeg.AccessibleName = "Sickle Cell Negative";
            this.cbOriginalSickleCellNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.cbOriginalSickleCellNeg.Enabled = false;
            this.cbOriginalSickleCellNeg.Location = new System.Drawing.Point(0, 40);
            this.cbOriginalSickleCellNeg.Name = "cbOriginalSickleCellNeg";
            this.cbOriginalSickleCellNeg.Size = new System.Drawing.Size(112, 20);
            this.cbOriginalSickleCellNeg.TabIndex = 17;
            this.cbOriginalSickleCellNeg.Text = "Sickle Cell &Neg";
            this.cbOriginalSickleCellNeg.Leave += new System.EventHandler(this.cbOriginalSickleCellNeg_Leave);
            // 
            // cbOriginalCMVNeg
            // 
            this.cbOriginalCMVNeg.AccessibleDescription = "C M V Negative";
            this.cbOriginalCMVNeg.AccessibleName = "C M V Negative";
            this.cbOriginalCMVNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.cbOriginalCMVNeg.Enabled = false;
            this.cbOriginalCMVNeg.Location = new System.Drawing.Point(0, 16);
            this.cbOriginalCMVNeg.Name = "cbOriginalCMVNeg";
            this.cbOriginalCMVNeg.Size = new System.Drawing.Size(112, 20);
            this.cbOriginalCMVNeg.TabIndex = 16;
            this.cbOriginalCMVNeg.Text = "C&MV Neg";
            this.cbOriginalCMVNeg.Leave += new System.EventHandler(this.cbOriginalCMVNeg_Leave);
            // 
            // txtOriginalDonationType
            // 
            this.txtOriginalDonationType.AccessibleDescription = "Donation Type";
            this.txtOriginalDonationType.AccessibleName = "Donation Type";
            this.txtOriginalDonationType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtOriginalDonationType.Location = new System.Drawing.Point(96, 4);
            this.txtOriginalDonationType.Name = "txtOriginalDonationType";
            this.txtOriginalDonationType.ReadOnly = true;
            this.txtOriginalDonationType.Size = new System.Drawing.Size(158, 20);
            this.txtOriginalDonationType.TabIndex = 10;
            this.txtOriginalDonationType.Leave += new System.EventHandler(this.txtOriginalDonationType_Leave);
            // 
            // lblOriginalDonationType
            // 
            this.lblOriginalDonationType.Location = new System.Drawing.Point(8, 4);
            this.lblOriginalDonationType.Name = "lblOriginalDonationType";
            this.lblOriginalDonationType.Size = new System.Drawing.Size(92, 20);
            this.lblOriginalDonationType.TabIndex = 65;
            this.lblOriginalDonationType.Text = "Donation Type";
            this.lblOriginalDonationType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pnlOriginalUnitInfo
            // 
            this.pnlOriginalUnitInfo.Controls.Add(this.updOriginalVolume);
            this.pnlOriginalUnitInfo.Controls.Add(this.lblOriginalVolume);
            this.pnlOriginalUnitInfo.Controls.Add(this.txtOriginalUnitStatus);
            this.pnlOriginalUnitInfo.Controls.Add(this.lblOriginalUnitStatus);
            this.pnlOriginalUnitInfo.Controls.Add(this.txtOriginalProductName);
            this.pnlOriginalUnitInfo.Controls.Add(this.txtOriginalABORh);
            this.pnlOriginalUnitInfo.Controls.Add(this.txtOriginalUnitID);
            this.pnlOriginalUnitInfo.Controls.Add(this.lblOriginalProductName);
            this.pnlOriginalUnitInfo.Controls.Add(this.txtOriginalExpirationDate);
            this.pnlOriginalUnitInfo.Controls.Add(this.lblOriginalExpirationDate);
            this.pnlOriginalUnitInfo.Controls.Add(this.lblOriginalABORh);
            this.pnlOriginalUnitInfo.Controls.Add(this.lblOriginalUnitID);
            this.pnlOriginalUnitInfo.Dock = System.Windows.Forms.DockStyle.Left;
            this.pnlOriginalUnitInfo.Location = new System.Drawing.Point(0, 0);
            this.pnlOriginalUnitInfo.Name = "pnlOriginalUnitInfo";
            this.pnlOriginalUnitInfo.Size = new System.Drawing.Size(298, 124);
            this.pnlOriginalUnitInfo.TabIndex = 1;
            // 
            // updOriginalVolume
            // 
            this.updOriginalVolume.AccessibleDescription = "Discard Plasma Volume Milliliters";
            this.updOriginalVolume.AccessibleName = "Discard Plasma Volume Milliliters";
            this.updOriginalVolume.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.updOriginalVolume.Location = new System.Drawing.Point(248, 52);
            this.updOriginalVolume.Maximum = new decimal(new int[] {
            2000,
            0,
            0,
            0});
            this.updOriginalVolume.Name = "updOriginalVolume";
            this.updOriginalVolume.Size = new System.Drawing.Size(40, 20);
            this.updOriginalVolume.TabIndex = 7;
            this.updOriginalVolume.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.updOriginalVolume.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.updOriginalVolume.TextChanged += new System.EventHandler(this.updOriginalVolume_ValueChanged);
            this.updOriginalVolume.ValueChanged += new System.EventHandler(this.updOriginalVolume_ValueChanged);
            this.updOriginalVolume.Leave += new System.EventHandler(this.updOriginalVolume_Leave);
            // 
            // lblOriginalVolume
            // 
            this.lblOriginalVolume.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblOriginalVolume.Location = new System.Drawing.Point(172, 48);
            this.lblOriginalVolume.Name = "lblOriginalVolume";
            this.lblOriginalVolume.Size = new System.Drawing.Size(96, 24);
            this.lblOriginalVolume.TabIndex = 69;
            this.lblOriginalVolume.Text = "Discard Plasma Volume (ml)*";
            this.lblOriginalVolume.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtOriginalUnitStatus
            // 
            this.txtOriginalUnitStatus.AccessibleDescription = "Unit Status";
            this.txtOriginalUnitStatus.AccessibleName = "Unit Status";
            this.txtOriginalUnitStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtOriginalUnitStatus.Location = new System.Drawing.Point(88, 100);
            this.txtOriginalUnitStatus.Name = "txtOriginalUnitStatus";
            this.txtOriginalUnitStatus.ReadOnly = true;
            this.txtOriginalUnitStatus.Size = new System.Drawing.Size(200, 20);
            this.txtOriginalUnitStatus.TabIndex = 9;
            this.txtOriginalUnitStatus.Leave += new System.EventHandler(this.txtOriginalUnitStatus_Leave);
            // 
            // lblOriginalUnitStatus
            // 
            this.lblOriginalUnitStatus.Location = new System.Drawing.Point(4, 100);
            this.lblOriginalUnitStatus.Name = "lblOriginalUnitStatus";
            this.lblOriginalUnitStatus.Size = new System.Drawing.Size(88, 20);
            this.lblOriginalUnitStatus.TabIndex = 68;
            this.lblOriginalUnitStatus.Text = "Unit Status";
            this.lblOriginalUnitStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtOriginalProductName
            // 
            this.txtOriginalProductName.AccessibleDescription = "Product ";
            this.txtOriginalProductName.AccessibleName = "Product ";
            this.txtOriginalProductName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtOriginalProductName.Location = new System.Drawing.Point(88, 28);
            this.txtOriginalProductName.Name = "txtOriginalProductName";
            this.txtOriginalProductName.ReadOnly = true;
            this.txtOriginalProductName.Size = new System.Drawing.Size(200, 20);
            this.txtOriginalProductName.TabIndex = 5;
            this.txtOriginalProductName.Leave += new System.EventHandler(this.txtOriginalProductName_Leave);
            // 
            // txtOriginalABORh
            // 
            this.txtOriginalABORh.AccessibleDescription = "A B O R H";
            this.txtOriginalABORh.AccessibleName = "A B O R H";
            this.txtOriginalABORh.Location = new System.Drawing.Point(88, 52);
            this.txtOriginalABORh.Name = "txtOriginalABORh";
            this.txtOriginalABORh.ReadOnly = true;
            this.txtOriginalABORh.Size = new System.Drawing.Size(80, 20);
            this.txtOriginalABORh.TabIndex = 6;
            this.txtOriginalABORh.Leave += new System.EventHandler(this.txtOriginalABORh_Leave);
            // 
            // txtOriginalUnitID
            // 
            this.txtOriginalUnitID.AccessibleDescription = "Unit I D";
            this.txtOriginalUnitID.AccessibleName = "Unit I D";
            this.txtOriginalUnitID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtOriginalUnitID.Location = new System.Drawing.Point(88, 4);
            this.txtOriginalUnitID.Name = "txtOriginalUnitID";
            this.txtOriginalUnitID.ReadOnly = true;
            this.txtOriginalUnitID.Size = new System.Drawing.Size(200, 20);
            this.txtOriginalUnitID.TabIndex = 4;
            this.txtOriginalUnitID.Leave += new System.EventHandler(this.txtOriginalUnitID_Leave);
            // 
            // lblOriginalProductName
            // 
            this.lblOriginalProductName.Location = new System.Drawing.Point(4, 28);
            this.lblOriginalProductName.Name = "lblOriginalProductName";
            this.lblOriginalProductName.Size = new System.Drawing.Size(96, 20);
            this.lblOriginalProductName.TabIndex = 66;
            this.lblOriginalProductName.Text = "Product";
            this.lblOriginalProductName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtOriginalExpirationDate
            // 
            this.txtOriginalExpirationDate.AccessibleDescription = "Expiration Date";
            this.txtOriginalExpirationDate.AccessibleName = "Expiration Date";
            this.txtOriginalExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtOriginalExpirationDate.Location = new System.Drawing.Point(88, 76);
            this.txtOriginalExpirationDate.Name = "txtOriginalExpirationDate";
            this.txtOriginalExpirationDate.ReadOnly = true;
            this.txtOriginalExpirationDate.Size = new System.Drawing.Size(200, 20);
            this.txtOriginalExpirationDate.TabIndex = 8;
            this.txtOriginalExpirationDate.Leave += new System.EventHandler(this.txtOriginalExpirationDate_Leave);
            // 
            // lblOriginalExpirationDate
            // 
            this.lblOriginalExpirationDate.Location = new System.Drawing.Point(4, 76);
            this.lblOriginalExpirationDate.Name = "lblOriginalExpirationDate";
            this.lblOriginalExpirationDate.Size = new System.Drawing.Size(88, 20);
            this.lblOriginalExpirationDate.TabIndex = 64;
            this.lblOriginalExpirationDate.Text = "Expiration Date";
            this.lblOriginalExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblOriginalABORh
            // 
            this.lblOriginalABORh.Location = new System.Drawing.Point(4, 52);
            this.lblOriginalABORh.Name = "lblOriginalABORh";
            this.lblOriginalABORh.Size = new System.Drawing.Size(80, 20);
            this.lblOriginalABORh.TabIndex = 63;
            this.lblOriginalABORh.Text = "ABO/Rh";
            this.lblOriginalABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblOriginalUnitID
            // 
            this.lblOriginalUnitID.Location = new System.Drawing.Point(4, 4);
            this.lblOriginalUnitID.Name = "lblOriginalUnitID";
            this.lblOriginalUnitID.Size = new System.Drawing.Size(92, 20);
            this.lblOriginalUnitID.TabIndex = 62;
            this.lblOriginalUnitID.Text = "Unit ID";
            this.lblOriginalUnitID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // tabOriginals
            // 
            this.tabOriginals.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.tabOriginals.Controls.Add(this.pageOriginalUnit1);
            this.tabOriginals.Location = new System.Drawing.Point(56, 64);
            this.tabOriginals.Name = "tabOriginals";
            this.tabOriginals.SelectedIndex = 0;
            this.tabOriginals.Size = new System.Drawing.Size(568, 152);
            this.tabOriginals.TabIndex = 3;
            this.tabOriginals.SelectedIndexChanged += new System.EventHandler(this.SourceTargetTabsClicked);
            this.tabOriginals.Leave += new System.EventHandler(this.tabOriginals_Leave);
            // 
            // pageOriginalUnit1
            // 
            this.pageOriginalUnit1.Location = new System.Drawing.Point(4, 23);
            this.pageOriginalUnit1.Name = "pageOriginalUnit1";
            this.pageOriginalUnit1.Size = new System.Drawing.Size(560, 125);
            this.pageOriginalUnit1.TabIndex = 0;
            this.pageOriginalUnit1.Text = "Original Unit 1";
            // 
            // tabTargets
            // 
            this.tabTargets.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.tabTargets.Controls.Add(this.pageTarget1);
            this.tabTargets.Location = new System.Drawing.Point(56, 216);
            this.tabTargets.Name = "tabTargets";
            this.tabTargets.SelectedIndex = 0;
            this.tabTargets.Size = new System.Drawing.Size(564, 246);
            this.tabTargets.TabIndex = 22;
            this.tabTargets.SelectedIndexChanged += new System.EventHandler(this.SourceTargetTabsClicked);
            this.tabTargets.Leave += new System.EventHandler(this.tabTargets_Leave);
            // 
            // pageTarget1
            // 
            this.pageTarget1.Location = new System.Drawing.Point(4, 23);
            this.pageTarget1.Name = "pageTarget1";
            this.pageTarget1.Size = new System.Drawing.Size(556, 219);
            this.pageTarget1.TabIndex = 0;
            this.pageTarget1.Text = "Target Unit 1";
            // 
            // pnlTop
            // 
            this.pnlTop.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlTop.Controls.Add(this.grpModificationDate);
            this.pnlTop.Controls.Add(this.grpWeld);
            this.pnlTop.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.pnlTop.Location = new System.Drawing.Point(0, 0);
            this.pnlTop.Name = "pnlTop";
            this.pnlTop.Size = new System.Drawing.Size(616, 60);
            this.pnlTop.TabIndex = 1;
            // 
            // grpModificationDate
            // 
            this.grpModificationDate.AccessibleDescription = "Modification";
            this.grpModificationDate.AccessibleName = "Modification";
            this.grpModificationDate.Controls.Add(this.txtModificationDate);
            this.grpModificationDate.Controls.Add(this.txtMethod);
            this.grpModificationDate.Controls.Add(this.lblMethod);
            this.grpModificationDate.Controls.Add(this.lblModificationDate);
            this.grpModificationDate.Dock = System.Windows.Forms.DockStyle.Fill;
            this.grpModificationDate.Location = new System.Drawing.Point(0, 0);
            this.grpModificationDate.Name = "grpModificationDate";
            this.grpModificationDate.Size = new System.Drawing.Size(488, 60);
            this.grpModificationDate.TabIndex = 0;
            this.grpModificationDate.TabStop = false;
            this.grpModificationDate.Text = "Modification";
            // 
            // txtModificationDate
            // 
            this.txtModificationDate.AccessibleDescription = "Modification Date";
            this.txtModificationDate.AccessibleName = "Modification Date";
            this.txtModificationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtModificationDate.Location = new System.Drawing.Point(100, 36);
            this.txtModificationDate.Name = "txtModificationDate";
            this.txtModificationDate.ReadOnly = true;
            this.txtModificationDate.Size = new System.Drawing.Size(380, 20);
            this.txtModificationDate.TabIndex = 1;
            // 
            // txtMethod
            // 
            this.txtMethod.AccessibleDescription = "Method";
            this.txtMethod.AccessibleName = "Method";
            this.txtMethod.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtMethod.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.txtMethod.Location = new System.Drawing.Point(100, 12);
            this.txtMethod.Name = "txtMethod";
            this.txtMethod.ReadOnly = true;
            this.txtMethod.Size = new System.Drawing.Size(380, 20);
            this.txtMethod.TabIndex = 0;
            // 
            // lblMethod
            // 
            this.lblMethod.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblMethod.Location = new System.Drawing.Point(8, 16);
            this.lblMethod.Name = "lblMethod";
            this.lblMethod.Size = new System.Drawing.Size(44, 16);
            this.lblMethod.TabIndex = 60;
            this.lblMethod.Text = "Method";
            this.lblMethod.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblModificationDate
            // 
            this.lblModificationDate.Location = new System.Drawing.Point(8, 36);
            this.lblModificationDate.Name = "lblModificationDate";
            this.lblModificationDate.Size = new System.Drawing.Size(96, 20);
            this.lblModificationDate.TabIndex = 58;
            this.lblModificationDate.Text = "Modification Date";
            this.lblModificationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpWeld
            // 
            this.grpWeld.AccessibleDescription = "Weld";
            this.grpWeld.AccessibleName = "Weld";
            this.grpWeld.Controls.Add(this.rdoIncomplete);
            this.grpWeld.Controls.Add(this.rdoComplete);
            this.grpWeld.Dock = System.Windows.Forms.DockStyle.Right;
            this.grpWeld.Location = new System.Drawing.Point(488, 0);
            this.grpWeld.Name = "grpWeld";
            this.grpWeld.Size = new System.Drawing.Size(128, 60);
            this.grpWeld.TabIndex = 0;
            this.grpWeld.TabStop = false;
            this.grpWeld.Text = "Weld*";
            // 
            // rdoIncomplete
            // 
            this.rdoIncomplete.AccessibleDescription = "Weld Incomplete";
            this.rdoIncomplete.AccessibleName = "Weld Incomplete";
            this.rdoIncomplete.Location = new System.Drawing.Point(8, 36);
            this.rdoIncomplete.Name = "rdoIncomplete";
            this.rdoIncomplete.Size = new System.Drawing.Size(108, 16);
            this.rdoIncomplete.TabIndex = 2;
            this.rdoIncomplete.Text = "Weld &Incomplete";
            this.rdoIncomplete.CheckedChanged += new System.EventHandler(this.rdoIncomplete_CheckedChanged);
            // 
            // rdoComplete
            // 
            this.rdoComplete.AccessibleDescription = "Weld Complete";
            this.rdoComplete.AccessibleName = "Weld Complete";
            this.rdoComplete.Location = new System.Drawing.Point(8, 16);
            this.rdoComplete.Name = "rdoComplete";
            this.rdoComplete.Size = new System.Drawing.Size(108, 16);
            this.rdoComplete.TabIndex = 2;
            this.rdoComplete.TabStop = true;
            this.rdoComplete.Text = "Wel&d Complete";
            this.rdoComplete.CheckedChanged += new System.EventHandler(this.rdoComplete_CheckedChanged);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.BackColor = System.Drawing.SystemColors.Control;
            this.grpImage.Controls.Add(this.picUnit);
            this.grpImage.Location = new System.Drawing.Point(0, 60);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 402);
            this.grpImage.TabIndex = 45;
            this.grpImage.TabStop = false;
            // 
            // picUnit
            // 
            this.picUnit.Image = ((System.Drawing.Image)(resources.GetObject("picUnit.Image")));
            this.picUnit.Location = new System.Drawing.Point(4, 12);
            this.picUnit.Name = "picUnit";
            this.picUnit.Size = new System.Drawing.Size(45, 45);
            this.picUnit.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picUnit.TabIndex = 38;
            this.picUnit.TabStop = false;
            // 
            // timer1
            // 
            this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
            // 
            // FrmModifyUnits
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(624, 523);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.pnlModify);
            this.hlphelpChm.SetHelpKeyword(this, "Modify_Unit.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(632, 550);
            this.Name = "FrmModifyUnits";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Modify Unit";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmModifyUnits_KeyDownSpeakMessage);
            this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.FrmModifyUnits_KeyDown);
            this.KeyUp += new System.Windows.Forms.KeyEventHandler(this.FrmModifyUnits_KeyUp);
            this.Leave += new System.EventHandler(this.FrmModifyUnits_Leave);
            this.Controls.SetChildIndex(this.pnlModify, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.pnlModify.ResumeLayout(false);
            this.pnlTargetUnit.ResumeLayout(false);
            this.pnltarget.ResumeLayout(false);
            this.tabSuppliesEquipment.ResumeLayout(false);
            this.pageContainer.ResumeLayout(false);
            this.pageSupplies.ResumeLayout(false);
            this.pageEquipment.ResumeLayout(false);
            this.pageSCDWafer.ResumeLayout(false);
            this.pnlTargetUnitTop.ResumeLayout(false);
            this.pnlTargetExtraInfo.ResumeLayout(false);
            this.pnlTargetExtraInfo.PerformLayout();
            this.tabTargetExtraInfo.ResumeLayout(false);
            this.pageTargetRestricted.ResumeLayout(false);
            this.pageTargetRestricted.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picTargetBiohazard)).EndInit();
            this.pageTargetAssigned.ResumeLayout(false);
            this.pageTargetSpecialTesting.ResumeLayout(false);
            this.pnlTargetUnitInfo.ResumeLayout(false);
            this.pnlTargetUnitInfo.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.updTargetVolume)).EndInit();
            this.pnlOriginalUnit.ResumeLayout(false);
            this.pnlOriginalExtraInfo.ResumeLayout(false);
            this.pnlOriginalExtraInfo.PerformLayout();
            this.tabOriginalExtraInfo.ResumeLayout(false);
            this.pageOriginalRestricted.ResumeLayout(false);
            this.pageOriginalRestricted.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picOriginalBiohazard)).EndInit();
            this.pageOriginalAssigned.ResumeLayout(false);
            this.pageOriginalSpecialTesting.ResumeLayout(false);
            this.pnlOriginalUnitInfo.ResumeLayout(false);
            this.pnlOriginalUnitInfo.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.updOriginalVolume)).EndInit();
            this.tabOriginals.ResumeLayout(false);
            this.tabTargets.ResumeLayout(false);
            this.pnlTop.ResumeLayout(false);
            this.grpModificationDate.ResumeLayout(false);
            this.grpModificationDate.PerformLayout();
            this.grpWeld.ResumeLayout(false);
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picUnit)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Control Events

		private void rdoComplete_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.rdoComplete.Checked)
				this._currentBUM.NewContainerWeldIndicator = true;
		}

		private void rdoIncomplete_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.rdoIncomplete.Checked)
				this._currentBUM.NewContainerWeldIndicator = false;
		}


		/// <summary>
		/// Blah blah blah
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpTargetExpirationDate_Leave(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.dtpTargetExpirationDate.Value == this._currentBUM.ModifiedUnit.UnitExpirationDate)
					return;

				//BR_26.21 - check the target's expiraton date
				if (this.dtpTargetExpirationDate.Value > this._currentBUM.ModifiedUnit.RecommendedExpirationDateTime(this._currentBUM))
				{
					if (ThisUser.CurrentDivisionRole.Role.UserRoleId >= Common.UserRoleType.EnhancedTechnologist)
					{
						if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.IssueExpiredBloodProducts))
						{
							DlgExpiredUnitConfirm dlgExpire = new DlgExpiredUnitConfirm(this._currentBUM.ModifiedUnit.NewUnit, Common.StrRes.ValidMsg.UC026.BR21TargetDateRange(this._currentBUM.ModifiedUnit.NewUnit.EyeReadableUnitId, this._currentBUM.ModifiedUnit.NewUnit.ProductType.ProductTypeText).ResString);
                            dlgExpire.ShowDialogFromLockedParent(this, false);

                            if (dlgExpire.DialogResult == DialogResult.Abort) return;

                            if (dlgExpire.DialogResult == DialogResult.OK)
							{
								this._currentBUM.ModifiedUnit.UnitExpirationDate = this.dtpTargetExpirationDate.Value;
								BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Target_product_outdate_extended, dlgExpire.Comment, Common.LogonUser.LogonUserName);
								exRep.GenerateExceptionUnitModification(this._currentBUM.ModifiedUnit.NewUnit, this._currentBUM, this._currentBUM.ModifiedUnit.RecommendedExpirationDateTime(this._currentBUM), null);
								this._currentBUM.Exceptions.Add(exRep);
							}
							else
							{
								//Since we're not disabling the OK button (nor changing the Objects value
								//Let the user see what's actually being saved
								this.dtpTargetExpirationDate.Value = this._currentBUM .ModifiedUnit.RecommendedExpirationDateTime(this._currentBUM);
							}
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
						}
					}
					else
					{
						//BR_26.28 - Security Level 1 check
						GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.BR28ExpirationDateOutOfRange(this._currentBUM.ModifiedUnit.NewUnit.EyeReadableUnitId, this._currentBUM.ModifiedUnit.NewUnit.ProductType.ProductTypeText));
						this.dtpTargetExpirationDate.Value = this._currentBUM.ModifiedUnit.UnitExpirationDate;
					}
				}
				else
				{
					this._currentBUM.ModifiedUnit.UnitExpirationDate = this.dtpTargetExpirationDate.Value;
				}				
			}
			this.GenericLeave(sender, e);
		}

		private void cmbTargetProductName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
            this.timer1.Enabled = true;     //LOCKING40 - refactor, combobox was causing memoryaccessexception
		}

		private bool ActivateBloodProduct( Guid bloodProductGuid, BOL.LocalSupplier localSupplier, bool isCodabar )
		{
            if( DAL.VAL.VistALink.EnsureAvailability() )
            {
				if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.ActivateEditBloodProductInformation))
				{
					FrmBloodProductEdit frmBPEdit = new FrmBloodProductEdit( bloodProductGuid, localSupplier, isCodabar);

                    //Abort means the user wasn't authorized, locks failed, etc. I should customize this too...TODO
					if (frmBPEdit.DialogResult != DialogResult.Abort)
					{
                        //LOCKING420 - ShowDialogFromLockedParent() - now with new improved locking!
                        frmBPEdit.ShowDialogFromLockedParent(this, true);
                        return (frmBPEdit.DialogResult == DialogResult.OK);
					}
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("edit blood product information"));

				}
            }
            return (false);
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
            int currentTab = this.CurrentIndex;

			if (!this.ProcessCurrentBUM()) return;
            
			if (this._bumControlList.Count == 0)
			{
				this.DialogResult = DialogResult.OK;
				this.Close();
			}
			else
			{
				currentTab = (currentTab < 2) ? 0 : --currentTab;
				this.tabTargets.SelectedIndex = currentTab;
				this.tabOriginals.SelectedIndex = currentTab;

				this._currentBUM = (BOL.BloodUnitModification)this._bumControlList[currentTab];

				this.PopulateTargetDetails();
				this.PopulateSourceDetails();
				this.ObjectValidityChange(this, System.EventArgs.Empty);
				
				//Setting the Tab Text, because the strict tab control is WHACKED!
				for(int ndx=0; ndx< this.tabOriginals.TabPages.Count; ndx++)
				{
					string tabText = ((BOL.BloodUnitModification)this._bumControlList[ndx]).OriginalUnit.EyeReadableUnitId;
					this.tabOriginals.TabPages[ndx].Text = tabText;
					this.tabTargets.TabPages[ndx].Text = tabText;
				}
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
            int currentTab = this.CurrentIndex;

            //Code from the VbecsBaseForm - need to Prompt user for each batch they're trying to cancel out of
            if (this.IsDirty)
            {
                // Alert the user if there have been changes asking to save the facility
                DialogResult _closingResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.UnsavedData());

                // If the user selects no, then cancel the event.
                if (_closingResult != DialogResult.Yes)
                {
                    return;
                }
            }

            //Since we've processed the modification, we can drop the locks
            //Lohse - 6/6/2005 - Removing BloodUnitStatus Locking - BUS change
            this.ReleaseLocks(this._currentBUM.OriginalUnit.BloodUnitGuid, this._currentBUM.OriginalUnit.BloodUnitMedia.BloodUnitMediaGuid);

            this._bumControlList.RemoveAt(currentTab);

            if (this._bumControlList.Count > 0)
            {
                this._removingTabs = true;
                this.tabOriginals.TabPages.RemoveAt(currentTab);
                this.tabTargets.TabPages.RemoveAt(currentTab);
                this._removingTabs = false;
            }

            if (this._bumControlList.Count == 0)
            {
                this.IsDirty = false;			//Have to set this to prevent the final close event from firing - baseform
                this.Close();
            }
            else
            {
                //Setup our remaining unit
                currentTab = (currentTab < 2) ? 0 : --currentTab;
                this.tabTargets.SelectedIndex = currentTab;
                this.tabOriginals.SelectedIndex = currentTab;

                this._currentBUM = (BOL.BloodUnitModification)this._bumControlList[currentTab];

                this.PopulateTargetDetails();
                this.PopulateSourceDetails();

                //Setting the Tab Text, because the strict tab control is WHACKED!
                for (int ndx = 0; ndx < this.tabOriginals.TabPages.Count; ndx++)
                {
                    string tabText = ((BOL.BloodUnitModification)this._bumControlList[ndx]).OriginalUnit.EyeReadableUnitId;
                    this.tabOriginals.TabPages[ndx].Text = tabText;
                    this.tabTargets.TabPages[ndx].Text = tabText;
                }

                this.ObjectValidityChange(this, System.EventArgs.Empty);
            }
		}

		private void updOriginalVolume_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					try
					{
						if (this._currentBUM.ModifiedUnit.NewUnit.DiscardedPlasmaVolume == this.updOriginalVolume.Value)
							return;

						//User is only allowed to change this value for Volume Reduce, so we don't
						//have to check ProductModificationCode, and set DiscardedPlasmaVolume
						//Change in BR_26.41 - No longer populates _currentBUM.OriginalUnit.DiscardedPlasmaVolume...
						this._currentBUM.ModifiedUnit.NewUnit.DiscardedPlasmaVolume = this.updOriginalVolume.Value;
					
						this.errError.SetVbecsError(this.updOriginalVolume, string.Empty); // **** 508 Compliance ***

						if (this._autoCalculate) return;

						this._autoCalculate = true;

						if (this._currentBUM.OriginalUnitVolume - this.updOriginalVolume.Value > this.updTargetVolume.Maximum)
						{
							this.updTargetVolume.Value = this.updTargetVolume.Maximum;
						}
						else
						{
							if(this._currentBUM.OriginalUnitVolume - this.updOriginalVolume.Value < this.updTargetVolume.Minimum)
							{
								this.updTargetVolume.Value = this.updTargetVolume.Minimum;
							}
							else
							{
								this.updTargetVolume.Value = this._currentBUM.OriginalUnitVolume - this.updOriginalVolume.Value ;
							}
						}

						this._autoCalculate = false;
					}
					catch(FormatException)
					{
						this._currentBUM.ModifiedUnit.NewUnit.DiscardedPlasmaVolume = decimal.MinusOne;
						this._autoCalculate = false;
					}
				}
			}
			catch(Exception err)
			{
				this._autoCalculate = false;
				this.errError.SetVbecsError(this.updOriginalVolume, err.Message); // **** 508 Compliance ***
			}
		}

		private void updOriginalVolume_Leave(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					try
					{
						if (this._currentBUM.ModifiedUnit.NewUnit.DiscardedPlasmaVolume == this.updOriginalVolume.Value)
							return;

						//User is only allowed to change this value for Volume Reduce, so we don't
						//have to check ProductModificationCode, and set DiscardedPlasmaVolume
						//Change in BR_26.41 - No longer populates _currentBUM.OriginalUnit.DiscardedPlasmaVolume...
						this._currentBUM.ModifiedUnit.NewUnit.DiscardedPlasmaVolume = this.updOriginalVolume.Value;
					
						this.errError.SetVbecsError(this.updOriginalVolume, string.Empty); // **** 508 Compliance ***

						if (this._autoCalculate) return;

						this._autoCalculate = true;

						if (this._currentBUM.OriginalUnitVolume - this.updOriginalVolume.Value > this.updTargetVolume.Maximum)
						{
							this.updTargetVolume.Value = this.updTargetVolume.Maximum;
						}
						else
						{
							if(this._currentBUM.OriginalUnitVolume - this.updOriginalVolume.Value < this.updTargetVolume.Minimum)
							{
								this.updTargetVolume.Value = this.updTargetVolume.Minimum;
							}
							else
							{
								this.updTargetVolume.Value = this._currentBUM.OriginalUnitVolume - this.updOriginalVolume.Value ;
							}
						}

						this._autoCalculate = false;
						this.GenericLeave(sender, e);
					}
					catch(FormatException err)
					{
						this._currentBUM.ModifiedUnit.NewUnit.DiscardedPlasmaVolume = decimal.MinusOne;
						this._autoCalculate = false;
						this.errError.SetVbecsError(this.updOriginalVolume, err.Message); // **** 508 Compliance ***
					}
				}
			}
			catch(Exception err)
			{
				this._autoCalculate = false;
				this.errError.SetVbecsError(this.updOriginalVolume, err.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// Target unit volume control change event, sets volume property of target unit
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void updTargetVolume_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					try
					{
						if (this._currentBUM.ModifiedUnit.NewUnit.OriginalVolume == this.updTargetVolume.Value)
							return;

						this._currentBUM.ModifiedUnit.NewUnit.OriginalVolume = this.updTargetVolume.Value;

						this.errError.SetVbecsError(this.updTargetVolume, string.Empty); // **** 508 Compliance ***

						if (this._autoCalculate) return;

						this._autoCalculate = true;

						if (this._currentBUM.OriginalUnitVolume - this.updTargetVolume.Value > this.updOriginalVolume.Maximum)
						{
							this.updOriginalVolume.Value = this.updOriginalVolume.Maximum;
						}
						else
						{
							if(this._currentBUM.OriginalUnitVolume - this.updTargetVolume.Value < this.updOriginalVolume.Minimum)
							{
								this.updOriginalVolume.Value = this.updOriginalVolume.Minimum;
							}
							else
							{
								this.updOriginalVolume.Value = this._currentBUM.OriginalUnitVolume - this.updTargetVolume.Value ;
							}
						}

						this._autoCalculate = false;	
					}
					catch(FormatException)
					{
						this._currentBUM.ModifiedUnit.NewUnit.OriginalVolume = decimal.MinusOne;
						this._autoCalculate = false;
					}
				}
			}
			catch(Exception err)
			{
				this._autoCalculate = false;
				this.errError.SetVbecsError(this.updTargetVolume, err.Message); // **** 508 Compliance ***
			}
		}

		private void updTargetVolume_Leave(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					try
					{
						if (this._currentBUM.ModifiedUnit.NewUnit.OriginalVolume == this.updTargetVolume.Value)
							return;

						this._currentBUM.ModifiedUnit.NewUnit.OriginalVolume = this.updTargetVolume.Value;

						this.errError.SetVbecsError(this.updTargetVolume, string.Empty); // **** 508 Compliance ***

						if (this._autoCalculate) return;

						this._autoCalculate = true;

						if (this._currentBUM.OriginalUnitVolume - this.updTargetVolume.Value > this.updOriginalVolume.Maximum)
						{
							this.updOriginalVolume.Value = this.updOriginalVolume.Maximum;
						}
						else
						{
							if(this._currentBUM.OriginalUnitVolume - this.updTargetVolume.Value < this.updOriginalVolume.Minimum)
							{
								this.updOriginalVolume.Value = this.updOriginalVolume.Minimum;
							}
							else
							{
								this.updOriginalVolume.Value = this._currentBUM.OriginalUnitVolume - this.updTargetVolume.Value ;
							}
						}

						this._autoCalculate = false;
						this.GenericLeave(sender, e);
					}
					catch(FormatException err)
					{
						this._currentBUM.ModifiedUnit.NewUnit.OriginalVolume = decimal.MinusOne;
						this._autoCalculate = false;
						this.errError.SetVbecsError(this.updTargetVolume, err.Message); // **** 508 Compliance ***
					}
				}
			}
			catch(Exception err)
			{
				this._autoCalculate = false;
				this.errError.SetVbecsError(this.updTargetVolume, err.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// Refreshes the ExpirationDate - attached to weldindicatorchange event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void RefreshExpirationDate(object sender, System.EventArgs e)
		{
			this._isLoading = true;
			this.dtpTargetExpirationDate.Value = this._currentBUM.ModifiedUnit.UnitExpirationDate;
			this._currentBUM.ModifiedUnit.TargetBloodProduct = null;
			this.PopulateTargetProductSelection();
			this._isLoading = false;
		}


		private void lvSupplies_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 4)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvSupplies.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvSupplies.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		private void lvEquipment_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvEquipment.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
		}

		private void lvSupplies_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			BOL.Supply trgSupply = (BOL.Supply)this.lvSupplies.Items[e.Index].Tag;
			int foundNdx = -1;

			for (int ndx=0; ndx < this._currentBUM.ModifiedUnit.SupplyList.Count; ndx++)
			{
				BOL.Supply srcSupply = (BOL.Supply)this._currentBUM.ModifiedUnit.SupplyList[ndx];

				if (srcSupply.SupplyGuid == trgSupply.SupplyGuid)
				{
					foundNdx = ndx;
					break;
				}
			}

			if (e.NewValue == System.Windows.Forms.CheckState.Checked)
			{
				if (foundNdx == -1)	//If they're checking and it doesn't already exist...add it
					this._currentBUM.ModifiedUnit.SupplyList.Add(trgSupply);
			}
			else
			{
				if (foundNdx > -1)	//They're unchecking and it's inside the list.... remove it
					this._currentBUM.ModifiedUnit.SupplyList.RemoveAt(foundNdx);
			}
		}

		private void lvEquipment_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			BOL.Equipment trgEquip = (BOL.Equipment)this.lvEquipment.Items[e.Index].Tag;
			int foundNdx = -1;

			for (int ndx=0; ndx < this._currentBUM.ModifiedUnit.EquipmentList.Count; ndx++)
			{
				BOL.Equipment srcEquip = (BOL.Equipment)this._currentBUM.ModifiedUnit.EquipmentList[ndx];

				if (srcEquip.EquipmentGuid == trgEquip.EquipmentGuid)
				{
					foundNdx = ndx;
					break;
				}
			}

			if (e.NewValue == System.Windows.Forms.CheckState.Checked)
			{
				if (foundNdx == -1)	//If they're checking and it doesn't already exist...add it
					this._currentBUM.ModifiedUnit.EquipmentList.Add(trgEquip);
			}
			else
			{
				if (foundNdx > -1)	//They're unchecking and it's inside the list.... remove it
					this._currentBUM.ModifiedUnit.EquipmentList.RemoveAt(foundNdx);
			}

		}

		/// <summary>
		/// Brings up DlgSelectSupply
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddContainer_Click(object sender, System.EventArgs e)
		{
			ArrayList usedSupplies = new ArrayList();
			usedSupplies.Add(this._currentBUM.ModifiedUnit.Container);

			DlgSelectSupply dlg = new DlgSelectSupply(Common.SupplyType.Containers,false, usedSupplies, this._currentBUM.OriginalUnit, this._currentBUM);
            dlg.ShowDialogFromLockedParent(this, false);

			if (dlg.DialogResult == DialogResult.OK)
			{
				this._currentBUM.ModifiedUnit.Container = (BOL.Supply)dlg.SelectedSupplyList[0];
				this.PopulateContainer();
			}
		}


		/// <summary>
		/// Brings up DlgSelectEquipment
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddEquipment_Click(object sender, System.EventArgs e)
		{
			DlgSelectEquipment dlg = new DlgSelectEquipment(this._currentBUM.ModifiedUnit.EquipmentList, this._currentBUM);
            dlg.ShowDialogFromLockedParent(this, false);

			if (dlg.DialogResult == DialogResult.OK)
			{
				this._currentBUM.ModifiedUnit.EquipmentList = dlg.SelectedEquipmentList;
				this.PopulateEquipment();
			}
		}


		/// <summary>
		/// Brings up DlgSelectSupply
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddSupplies_Click(object sender, System.EventArgs e)
		{
			DlgSelectSupply dlg = new DlgSelectSupply(Common.SupplyType.AllSupplies, true, this._currentBUM.ModifiedUnit.SupplyList, this._currentBUM.OriginalUnit, this._currentBUM);
            dlg.ShowDialogFromLockedParent(this, false);

			if (dlg.DialogResult == DialogResult.OK)
			{
				this._currentBUM.ModifiedUnit.SupplyList = dlg.SelectedSupplyList;
				this.PopulateSupplies();
			}
		}


		/// <summary>
		/// Brings up DlgSelectSupply
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddWafer_Click(object sender, System.EventArgs e)
		{
			ArrayList usedSupplies = new ArrayList();
			usedSupplies.Add(this._currentBUM.ModifiedUnit.SCDWafer);

			DlgSelectSupply dlg = new DlgSelectSupply(Common.SupplyType.SCDWafer, false, usedSupplies, this._currentBUM.OriginalUnit, this._currentBUM);
            dlg.ShowDialogFromLockedParent(this, false);

			if (dlg.DialogResult == DialogResult.OK)
			{
				this._currentBUM.ModifiedUnit.SCDWafer = (BOL.Supply)dlg.SelectedSupplyList[0];
				this.PopulateSCDWafer();
			}
		}

		#endregion

		#region Properties

		/// <summary>
		/// Shortcut so I don't have to type all that this.tab....
		/// </summary>
		private int CurrentIndex
		{
			get
			{
				return this.tabOriginals.SelectedIndex;
			}
		}

		private string Title
		{
			get
			{
				//Set the title of the form
				switch (this._currentBUM.ProductModificationCode)
				{
					case Common.ProductModification.Deglycerolized:
						return("Deglycerolize Unit");

					case Common.ProductModification.Thawed:
						return("Thaw Unit");
						
					case Common.ProductModification.Frozen:
						return("Freeze Unit");
		
					case Common.ProductModification.Irradiated:
						return("Irradiate Unit");

					case Common.ProductModification.LeukoReduced:
						return("Leuko Reduce Unit");
					
					case Common.ProductModification.Rejuvenated:
						return("Rejuvenate Unit");
					
					case Common.ProductModification.Washed:
						return("Wash Unit");
						
					case Common.ProductModification.VolumeReduced:
						return("Volume Reduce Unit");
				}

				return string.Empty;
			}
		}


		#endregion

		#region Events

		/// <summary>
		/// Fires when properties are set on any of our parent/child objects
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ObjectValidityChange(object sender, System.EventArgs e)
		{
			string tooltipMsg = this._currentBUM.GetBrokenRulesMessage(this.Name);
			
			if (tooltipMsg == string.Empty)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
				this.btnOK.EnabledButton = true;
			}
			else
			{
				this.btnOK.SetToolTip(tooltipMsg);
				this.btnOK.EnabledButton = false;
			}

			this.SetDirtyFlag(this, System.EventArgs.Empty);
		}

		/// <summary>
		/// This makes the original and target tiny little "extra info" tabs switch at the same time
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ExtraInfoTabsClicked(object sender, System.EventArgs e)
		{
			if (sender == this.tabOriginalExtraInfo)
			{
				this.tabTargetExtraInfo.SelectedIndex = this.tabOriginalExtraInfo.SelectedIndex;
				this.tabOriginalExtraInfo.Focus();
			}
			else if (sender == this.tabTargetExtraInfo)
			{
				this.tabOriginalExtraInfo.SelectedIndex = this.tabTargetExtraInfo.SelectedIndex;
				this.tabTargetExtraInfo.Focus();
			}
			
			base.ResetLockTimer(this, System.EventArgs.Empty);
		}

		/// <summary>
		/// This will switch the original/target tabs click at the same time
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void SourceTargetTabsClicked(object sender, System.EventArgs e)
		{
			//This gets fired twice, once on each tab switch -- change to only call once
			if (!this._removingTabs)
			{
				//Setting the Tab Text, because the strict tab control is WHACKED!
				for(int ndx=0; ndx< this.tabOriginals.TabPages.Count; ndx++)
				{
					string tabText = ((BOL.BloodUnitModification)this._bumControlList[ndx]).OriginalUnit.EyeReadableUnitId;
					this.tabOriginals.TabPages[ndx].Text = tabText;
					this.tabTargets.TabPages[ndx].Text = tabText;
				}

				this._currentBUM = (BOL.BloodUnitModification)this._bumControlList[this.CurrentIndex];

				if (sender == this.tabOriginals)
				{
					this.tabTargets.SelectedIndex = this.tabOriginals.SelectedIndex;
					this.PopulateTargetDetails();
				}
				if (sender == this.tabTargets)
				{
					this.tabOriginals.SelectedIndex = this.tabTargets.SelectedIndex;
					this.PopulateSourceDetails();
				}

				//Fire the event to refresh the OK button's enabled state
				this.ObjectValidityChange(this, System.EventArgs.Empty);

				this.btnOK.RowVersionException = System.Convert.ToBoolean(this._btnOKRowVersionException[this.CurrentIndex]);
			}
		}

		private void tabSuppliesEquipment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			base.ResetLockTimer(this, System.EventArgs.Empty);
		}

		private void dtpTargetExpirationDate_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			base.ResetLockTimer(this, System.EventArgs.Empty);
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmModifyUnits_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			if ( !this.btnOK.EnabledButton )
			{
				this.SpeakMessage( this.btnOK.GetToolTip() );
			}
		}

		#endregion

		#region Methods

		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;

			this._targetProductList = new System.Collections.ArrayList();

			//Set custom date and time format
			this.dtpTargetExpirationDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			this.dtpTargetExpirationDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			//Setup the Modifiation Method
			switch (this._currentBUM.ModificationMethod)
			{
				case (Common.ModifyUnitMethod.Open):
					this.txtMethod.Text = "Open";
					this.EnableContainer(true);
					this.EnableSCDWafer(false);
					break;

					//BR_26.37, Closed -- cannnot assign container
				case (Common.ModifyUnitMethod.Closed):
					this.txtMethod.Text = "Closed";
					this.EnableContainer(false);
					this.EnableSCDWafer(false);
					break;
				
				case (Common.ModifyUnitMethod.SterileConnectingDevice):
					this.txtMethod.Text = "Sterile Connection Device";
					this.EnableSCDWafer(true);
					this.EnableContainer(true);
					break;
			}

			this.vbecsLogo1.Title = this.Title;
			this.Text = "VBECS - " + this.Title;

			this.txtModificationDate.Text = Common.VBECSDateTime.FormatDateTimeString(this._currentBUM.ModificationDateTime);

			//Set the tooltips
			this.toolTip1.SetToolTip(this.txtOriginalProductName, this._currentBUM.OriginalUnit.ProductName);

			this.toolTip1.SetToolTip(this.dtpTargetExpirationDate, Common.StrRes.Tooltips.UC026.TargetExpirationDate().ResString);
			this.toolTip1.SetToolTip(this.txtTargetUnitId, Common.StrRes.Tooltips.UC026.TargetUnitId().ResString);
			this.toolTip1.SetToolTip(this.txtTargetABORh, Common.StrRes.Tooltips.UC026.TargetAboRH().ResString);
			this.toolTip1.SetToolTip(this.updTargetVolume, Common.StrRes.Tooltips.UC026.TargetVolume().ResString);
			this.toolTip1.SetToolTip(this.txtTargetUnitStatus, Common.StrRes.Tooltips.UC026.TargetUnitStatus().ResString);
			this.toolTip1.SetToolTip(this.txtTargetDonationType, Common.StrRes.Tooltips.UC026.TargetDonationType().ResString);
			this.toolTip1.SetToolTip(this.cbTargetCMVNeg, Common.StrRes.Tooltips.UC026.TargetCMVNegative().ResString);
			this.toolTip1.SetToolTip(this.cbTargetSickleCellNeg, Common.StrRes.Tooltips.UC026.TargetSickleCellNegative().ResString);
			this.toolTip1.SetToolTip(this.lvTargetAntigens, Common.StrRes.Tooltips.UC026.TargetAntigens().ResString);
			this.toolTip1.SetToolTip(this.lblTargetCMVNeg, Common.StrRes.Tooltips.UC026.TargetCMVNegative().ResString);
			this.toolTip1.SetToolTip(this.lblTargetSickleCellNeg, Common.StrRes.Tooltips.UC026.TargetSickleCellNegative().ResString);
			this.toolTip1.SetToolTip(this.txtTargetRestrictedName, Common.StrRes.Tooltips.UC026.TargetRestrictedName().ResString);
			this.toolTip1.SetToolTip(this.txtTargetRestrictedSSN, Common.StrRes.Tooltips.UC026.TargetRestrictedSSN().ResString);
			this.toolTip1.SetToolTip(this.txtTargetRestrictedStatus, Common.StrRes.Tooltips.UC026.TargetRestrictedStatus().ResString);
			this.toolTip1.SetToolTip(this.lvSCDWafer, Common.StrRes.Tooltips.UC026.WaferList().ResString);
			this.toolTip1.SetToolTip(this.btnAddWafer, Common.StrRes.Tooltips.UC026.AddWafer().ResString);
			this.toolTip1.SetToolTip(this.lvEquipment, Common.StrRes.Tooltips.UC026.EquipmentList().ResString);
			this.toolTip1.SetToolTip(this.btnAddEquipment, Common.StrRes.Tooltips.UC026.AddEquipment().ResString);
			this.toolTip1.SetToolTip(this.lvSupplies, Common.StrRes.Tooltips.UC026.SupplyList().ResString);
			this.toolTip1.SetToolTip(this.btnAddSupplies, Common.StrRes.Tooltips.UC026.AddSupplies().ResString);
			this.toolTip1.SetToolTip(this.lvContainer, Common.StrRes.Tooltips.UC026.ContainerList().ResString);
			this.toolTip1.SetToolTip(this.btnAddContainer, Common.StrRes.Tooltips.UC026.AddContainer().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalExpirationDate, Common.StrRes.Tooltips.UC026.OriginalExpirationDate().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalUnitID, Common.StrRes.Tooltips.UC026.OriginalUnitId().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalABORh, Common.StrRes.Tooltips.UC026.OriginalAboRH().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalUnitStatus, Common.StrRes.Tooltips.UC026.OriginalUnitStatus().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalDonationType, Common.StrRes.Tooltips.UC026.OriginalDonationType().ResString);
			this.toolTip1.SetToolTip(this.cbOriginalCMVNeg, Common.StrRes.Tooltips.UC026.OriginalCMVNegative().ResString);
			this.toolTip1.SetToolTip(this.cbOriginalSickleCellNeg, Common.StrRes.Tooltips.UC026.OriginalSickleCellNeg().ResString);
			this.toolTip1.SetToolTip(this.lvOriginalAntigens, Common.StrRes.Tooltips.UC026.OriginalAntigens().ResString);
			this.toolTip1.SetToolTip(this.lblOriginalCMVNeg, Common.StrRes.Tooltips.UC026.OriginalCMVNegative().ResString);
			this.toolTip1.SetToolTip(this.lblOriginalSickleCellNeg, Common.StrRes.Tooltips.UC026.OriginalSickleCellNeg().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalRestrictedName, Common.StrRes.Tooltips.UC026.OriginalRestrictedName().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalRestrictedSSN, Common.StrRes.Tooltips.UC026.OriginalRestrictedSSN().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalRestrictedStatus, Common.StrRes.Tooltips.UC026.OriginalRestrictedStatus().ResString);
			this.toolTip1.SetToolTip(this.rdoIncomplete, Common.StrRes.Tooltips.UC026.IncompleteWeld().ResString);
			this.toolTip1.SetToolTip(this.rdoComplete, Common.StrRes.Tooltips.UC026.CompleteWeld().ResString);
		}


		/// <summary>
		/// Sets the enabled properties of the Container listview/Buttons
		/// </summary>
		/// <param name="enable"></param>
		private void EnableContainer(bool enable)
		{
			if (enable)
				this.btnAddContainer.Text = "Add Container*";
			else
				this.btnAddContainer.Text = "Add Container";

			this.lvContainer.Enabled = enable;
			this.btnAddContainer.Enabled = enable;
		}


		/// <summary>
		/// Sets the enabled properties of the SCDWafer listview/Buttons
		/// </summary>
		/// <param name="enable"></param>
		private void EnableSCDWafer(bool enable)
		{
			if (enable)
				this.btnAddWafer.Text = "Add Wafer*";
			else
				this.btnAddWafer.Text = "Add Wafer";

			this.grpWeld.Enabled = enable;
			this.lvSCDWafer.Enabled = enable;
			this.btnAddWafer.Enabled = enable;
		}

		private void PopulateSourceDetails()
		{
			//BR_26.41 -- disable the target right away too
			if (this._currentBUM.ProductModificationCode == Common.ProductModification.VolumeReduced)
			{
				this.lblOriginalVolume.Text = "Discarded Plasma Volume (ml)*";
				this.updOriginalVolume.Enabled = true;
				this.updTargetVolume.Enabled = true;
				this.updOriginalVolume.Value = this._currentBUM.OriginalUnit.DiscardedPlasmaVolume;		//Defaults to one for discard
				this.updOriginalVolume.Minimum = 1;
				this.updOriginalVolume.Maximum = this._currentBUM.OriginalUnit.OriginalVolume-1;
				this.updTargetVolume.Minimum = 1;
				this.updTargetVolume.Maximum = this._currentBUM.OriginalUnit.OriginalVolume-1;		//Account for discard min
			}
			else
			{
				this.lblOriginalVolume.Text = "Volume (ml)";
				this.updOriginalVolume.Value = this._currentBUM.OriginalUnit.OriginalVolume;
				this.updOriginalVolume.Enabled = false;
				this.updTargetVolume.Enabled = false;
			}

			this.txtOriginalUnitID.Text = this._currentBUM.OriginalUnit.EyeReadableUnitId;
			this.txtOriginalProductName.Text = this._currentBUM.OriginalUnit.FullProductCode + " - " + this._currentBUM.OriginalUnit.ProductShortName;
			this.txtOriginalABORh.Text = this._currentBUM.OriginalUnit.BloodUnitMedia.AboRh.AboRHText;
			this.toolTip1.SetToolTip(this.txtOriginalABORh, this._currentBUM.OriginalUnit.BloodUnitMedia.AboRh.AboRHTextExpanded);

			this.txtOriginalExpirationDate.Text = Common.VBECSDateTime.FormatDateTimeString(this._currentBUM.OriginalUnit.BloodUnitMedia.UnitExpirationDate);
			this.txtOriginalDonationType.Text = this._currentBUM.OriginalUnit.DonationType.DonationTypeText;
			this.txtOriginalUnitStatus.Text = this._currentBUM.OriginalUnit.BloodUnitStatus.UnitStatusDescriptiveText;

			
			this.txtOriginalRestrictedName.Text = this._currentBUM.OriginalUnit.DirectedPatient.DisplayName;
			this.txtOriginalRestrictedSSN.Text = this._currentBUM.OriginalUnit.DirectedPatient.DisplayPatientID;//this._currentBUM.DirectedPatient.SSN;
			this.txtOriginalRestrictedStatus.Text = BOL.TestingStatus.GetTestingStatusTextFromID(this._currentBUM.OriginalUnit.BloodUnitMedia.TestingStatusId);
			this.picOriginalBiohazard.Visible = this._currentBUM.OriginalUnit.BloodUnitStatus.BiohazardousWarningIndicator;

			this.lvOriginalAssigned.Items.Clear();
			if (this._currentBUM.OriginalUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.CrossmatchedAssigned ||
				this._currentBUM.OriginalUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Assigned)
			{
				System.Data.DataTable dtAssignments = BOL.PatientAssignments.GetPatientSpecimenAssignmentDetails(this._currentBUM.OriginalUnit.BloodUnitGuid);
				
				foreach(System.Data.DataRow dr in dtAssignments.Rows)
				{
					System.Guid patientGuid = (System.Guid)dr[PATIENT.PatientGuid];
					BOL.Patient patient = new BOL.Patient(patientGuid);

					//Populate the list view with the appropriate data
					ListViewItem lvi = new ListViewItem(patient.DisplayName);
					lvi.SubItems.Add(patient.DisplayPatientID);//patient.SSN.ToString().Insert(3,"-").Insert(6,"-"));
					//
					System.Guid specimenGuid = dr.IsNull(PATIENTSPECIMEN.PatientSpecimenGuid) ? Guid.Empty : (System.Guid)dr[Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid];
					if (specimenGuid != Guid.Empty)
					{
						BOL.Specimen specimen = new BOL.Specimen(specimenGuid);
						lvi.SubItems.Add(specimen.SpecimenUid);
						lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(specimen.SpecimenExpirationDate));
					}
					this.lvOriginalAssigned.Items.Add(lvi);
					
				}
				GUI.controls.VbecsFunction.SetColumnWidths(this.lvOriginalAssigned);
			}

			this.cbOriginalCMVNeg.Checked = this._currentBUM.OriginalUnit.CmvNegative;
			this.cbOriginalSickleCellNeg.Checked = this._currentBUM.OriginalUnit.SickleCellNegative;
			this.PopulateAntigenListview();

			//BR_26.41
			//			this.pnlDiscardPlasma.Visible = (this._currentBUM.ProductModificationCode == Common.ProductModification.VolumeReduced);
			//			this.lblOriginalVolume.Visible = (!this.pnlDiscardPlasma.Visible);
			//			this.txtOriginalVolume.Visible = (!this.pnlDiscardPlasma.Visible);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to search on file for valid target products for current blood unit modification, and populate UI control
		/// Indentical code in UC26.FrmPoolUnits
		/// </summary>
		private void PopulateTargetProductSelection()
		{
			try
			{
				//We need this set as form-level so we can access the other information later
				System.Data.DataTable dtProducts = this._currentBUM.GetTargetBloodProducts(this._currentBUM.GetBloodProductGuidArray());
				
				this.cmbTargetProductName.Items.Clear();
				this._targetProductList.Clear();

				bool isISBT = (this._currentBUM.ModifiedUnit.NewUnit.BarcodeType == Common.BarcodeType.ISBT128);

				foreach (System.Data.DataRow dr in dtProducts.Rows)
				{
					if (isISBT)
					{
						string productName = dr[BLOODPRODUCT.ProductCode].ToString() + this._currentBUM.ModifiedUnit.NewUnit.DonationType.DonationTypeCode.ToString() + this._currentBUM.ModifiedUnit.NewUnit.UnitDivisionId;
						this.cmbTargetProductName.Items.Add(productName + " - " + dr[BLOODPRODUCT.ProductShortName].ToString());
					}
					else
						this.cmbTargetProductName.Items.Add(dr[Common.DatabaseConstants.ArtificialColumnNames.CodeAndShortName].ToString());

					//Save off the datarow for later use -- allows us to dump the datatable
					this._targetProductList.Add(dr);
				}

				if (dtProducts.Rows.Count == 0)
					this.toolTip1.SetToolTip(this.cmbTargetProductName, Common.StrRes.Tooltips.UC026.NoTargetProducts().ResString);
				else
					this.toolTip1.SetToolTip(this.cmbTargetProductName, Common.StrRes.Tooltips.UC026.SelectTargetProduct().ResString);

			}
			catch (Exception err)
			{
				this.errError.SetVbecsError(this.cmbTargetProductName, err.Message); // **** 508 Compliance ***
			}
		}

		private void PopulateTargetDetails()
		{
			bool tmpLoading = this._isLoading;

			this.PopulateTargetProductSelection();
			
			this._isLoading = true;

			if (!this._isFirstTime)
			{
				for(int ndx=0; ndx < this._targetProductList.Count; ndx++)
				{
					System.Data.DataRow dr = (System.Data.DataRow)this._targetProductList[ndx];

					if((System.Guid)dr[BLOODPRODUCT.BloodProductGuid] == this._currentBUM.ModifiedUnit.TargetBloodProduct.BloodProductGuid)
					{
						this.cmbTargetProductName.SelectedIndex = ndx;
						break;
					}
				}
			}

			this._isLoading = tmpLoading;

			this.txtTargetUnitId.Text = this._currentBUM.ModifiedUnit.NewUnit.EyeReadableUnitId;
			this.toolTip1.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.UC026.CancelBatchTab(this.txtTargetUnitId.Text).ResString);

			this.txtTargetABORh.Text = this._currentBUM.ModifiedUnit.NewUnit.BloodUnitMedia.AboRh.AboRHText;
			this.toolTip1.SetToolTip(this.txtTargetABORh, this._currentBUM.ModifiedUnit.NewUnit.BloodUnitMedia.AboRh.AboRHTextExpanded);

			this.dtpTargetExpirationDate.Value = this._currentBUM.ModifiedUnit.UnitExpirationDate;
			this.txtTargetDonationType.Text = this._currentBUM.ModifiedUnit.NewUnit.DonationType.DonationTypeText;
			this.updTargetVolume.Value = this._currentBUM.ModifiedUnit.NewUnit.OriginalVolume;
			//
			this.txtTargetRestrictedName.Text = this._currentBUM.ModifiedUnit.NewUnit.DirectedPatient.DisplayName;
			this.txtTargetRestrictedSSN.Text = this._currentBUM.ModifiedUnit.NewUnit.DirectedPatient.DisplayPatientID;//.SSN;
			this.txtTargetRestrictedStatus.Text = BOL.TestingStatus.GetTestingStatusTextFromID(this._currentBUM.ModifiedUnit.NewUnit.BloodUnitMedia.TestingStatusId);
			this.picTargetBiohazard.Visible = this._currentBUM.ModifiedUnit.NewUnit.BloodUnitStatus.BiohazardousWarningIndicator;

			this.txtTargetUnitStatus.Text = this._currentBUM.ModifiedUnit.NewUnit.BloodUnitStatus.UnitStatusDescriptiveText;

			//Replicate the original listview
			this.lvTargetAntigens.Items.Clear();
			foreach (ListViewItem lvi in this.lvOriginalAntigens.Items)
			{
				this.lvTargetAntigens.Items.Add((ListViewItem)lvi.Clone());
			}
			GUI.controls.VbecsFunction.SetColumnWidths(this.lvTargetAntigens);

			//Enable the CMV & SickleCell tests
			this.cbTargetCMVNeg.Checked = this.cbOriginalCMVNeg.Checked;
			this.cbTargetSickleCellNeg.Checked = this.cbOriginalSickleCellNeg.Checked;

			this.PopulateContainer();
			this.PopulateEquipment();
			this.PopulateSCDWafer();
			this.PopulateSupplies();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/2/2002</CreationDate>
		///
		/// <summary>
		/// Populates the antigens tested, in the little listview
		/// </summary>
		private void PopulateAntigenListview()
		{
			this.lvOriginalAntigens.Items.Clear();

			//This will include antigens from UC1 as well as UC41
			System.Data.DataSet dsAntigens = BOL.DiscardOrQuarantineBloodUnit.GetAntigenTypingForConsistencyCheck(this._currentBUM.OriginalUnit.BloodUnitGuid);

			if (dsAntigens.Tables.Count > 1)
			{
				foreach (System.Data.DataRow drItem in dsAntigens.Tables[1].Rows)
				{
					ListViewItem lvi = new ListViewItem();
				
					lvi.Text = drItem[ANTIGENTYPE.AntigenTypeName].ToString().Trim();
									
					if (System.Convert.ToBoolean(drItem[BLOODUNITANTIGEN.Positive]))
					{
						lvi.SubItems.Add("POS");
					}
					else
					{
						lvi.SubItems.Add("NEG");
					}
					this.lvOriginalAntigens.Items.Add(lvi);
				}
			}
			
			GUI.controls.VbecsFunction.SetColumnWidths(this.lvOriginalAntigens);
		}

		/// <summary>
		/// Populates the Equipment listview from the modified units's EquipmentList property
		/// </summary>
		private void PopulateEquipment()
		{
			int nCount = 0;
			this.lvEquipment.Items.Clear();
			
			if (this._currentBUM.ModifiedUnit.EquipmentList.Count > 0)
			{
				nCount = this._currentBUM.ModifiedUnit.EquipmentList.Count;
				for(int ndx=0; ndx < nCount; ndx++)
				{
					ListViewItem lvi = new ListViewItem();
					BOL.Equipment equip = (BOL.Equipment)this._currentBUM.ModifiedUnit.EquipmentList[ndx];
					
					lvi.Tag = equip;
					lvi.Checked = true;
					lvi.SubItems.Add(equip.SerialNumber);
					lvi.SubItems.Add(equip.EquipmentName);
					lvi.SubItems.Add(equip.ManufacturerName);
					lvi.SubItems.Add(equip.LocalIdentifier);
					
					this.lvEquipment.Items.Add(lvi);
				}
			}
			GUI.controls.VbecsFunction.SetColumnWidths(this.lvEquipment);
		}

		
		/// <summary>
		/// SCD Wafer is some kinda supply thing that's required? when you perform a SCD modification
		/// </summary>
		private void PopulateSCDWafer()
		{
			this.lvSCDWafer.Items.Clear();
			
			if (this._currentBUM.ModifiedUnit.SCDWafer.LotNumber != string.Empty)
			{
			
				ListViewItem lvi = new ListViewItem();

				lvi.Text = this._currentBUM.ModifiedUnit.SCDWafer.LotNumber;
				lvi.SubItems.Add(this._currentBUM.ModifiedUnit.SCDWafer.SupplyName);
				lvi.SubItems.Add(this._currentBUM.ModifiedUnit.SCDWafer.ManufacturerName);
				lvi.SubItems.Add(Common.VBECSDateTime.FormatDateString(this._currentBUM.ModifiedUnit.SCDWafer.LotExpirationDate));
				
				this.lvSCDWafer.Items.Add(lvi);
			}

			GUI.controls.VbecsFunction.SetColumnWidths(this.lvSCDWafer);
		}


		/// <summary>
		/// Loads the container for the modified unit
		/// </summary>
		private void PopulateContainer()
		{

			this.lvContainer.Items.Clear();
			
			if (this._currentBUM.ModifiedUnit.Container.LotNumber != string.Empty)
			{
				ListViewItem lvi = new ListViewItem();

				lvi.Text = this._currentBUM.ModifiedUnit.Container.LotNumber;
				lvi.SubItems.Add(this._currentBUM.ModifiedUnit.Container.SupplyName);
				lvi.SubItems.Add(this._currentBUM.ModifiedUnit.Container.ManufacturerName);
				lvi.SubItems.Add(Common.VBECSDateTime.FormatDateString(this._currentBUM.ModifiedUnit.Container.LotExpirationDate));
				
				this.lvContainer.Items.Add(lvi);
			}

			GUI.controls.VbecsFunction.SetColumnWidths(this.lvContainer);
		}


		/// <summary>
		/// Populates the Supply listview from the modified units's SupplyList property
		/// </summary>
		private void PopulateSupplies()
		{
			int nCount = 0;
			this.lvSupplies.Items.Clear();
			
			if (this._currentBUM.ModifiedUnit.SupplyList.Count > 0)
			{
				nCount = this._currentBUM.ModifiedUnit.SupplyList.Count;
				for(int ndx=0; ndx < nCount; ndx++)
				{
					ListViewItem lvi = new ListViewItem();
					BOL.Supply supply = (BOL.Supply)this._currentBUM.ModifiedUnit.SupplyList[ndx];

					lvi.Tag = supply;
					lvi.Checked = true;
					lvi.SubItems.Add(supply.LotNumber);
					lvi.SubItems.Add(supply.SupplyName);
					lvi.SubItems.Add(supply.ManufacturerName);
					lvi.SubItems.Add(Common.VBECSDateTime.FormatDateString(supply.LotExpirationDate));
					
					this.lvSupplies.Items.Add(lvi);
				}
			}
			
			GUI.controls.VbecsFunction.SetColumnWidths(this.lvSupplies);
		}

		/// <summary>
		/// Does the save of the current BUM and then removes the tab from the form
		/// </summary>
		private bool ProcessCurrentBUM()
		{
			bool retValue = false;
			ArrayList incompleteOrders = new ArrayList();

			int currentTab = this.CurrentIndex;
			ArrayList labelMismatchExceptions = new ArrayList();
			string modification = Common.Utility.GetProductModificationTextFromEnum(this._currentBUM.ProductModificationCode);

			//Check for BloodUnit Uniqueness..........JIC-- we no longer insert new rows, so only check this if product changes
			if (this._currentBUM.OriginalUnit.BloodProductGuid != this._currentBUM.ModifiedUnit.TargetBloodProduct.BloodProductGuid)
			{
				System.Guid buGuid = System.Guid.Empty;
				//CR 2587
				if (BOL.BloodUnit.BloodUnitExists(this._currentBUM.ModifiedUnit.NewUnit.EyeReadableUnitId, this._currentBUM.ModifiedUnit.NewUnit.BloodProductGuid, this._currentBUM.ModifiedUnit.NewUnit.FullProductCode, ref buGuid))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.BR1_40(this._currentBUM.ModifiedUnit.NewUnit.EyeReadableUnitId, this._currentBUM.ModifiedUnit.NewUnit.FullProductCode));
					return(false);
				}
			}

			//BR_26.25
			if (this._currentBUM.OriginalUnit.AssignedToPatients.Count > 0)
			{
				DlgModifyAssignments dlgPatientAssignments = new DlgModifyAssignments(this._currentBUM.OriginalUnit);
                dlgPatientAssignments.ShowDialogFromLockedParent(this, false);

                if (dlgPatientAssignments.DialogResult == DialogResult.Abort) return (false);

                if (dlgPatientAssignments.DialogResult == DialogResult.OK)
				{
					this._currentBUM.InheritedPatientAssignment = dlgPatientAssignments.SelectedPatientAssignment;
				}

				//KD this code is a part of BR_92.02. It is possible that by modifying an assigned unit the user made it available for issue.
				//When the unit becomes available for issue we have to check if the order for which the unit is assigned becomes filled.
				//If so the order completion message has to be sent to Vista.
				for (int ndx=0; ndx < this._currentBUM.OriginalUnit.AssignedToPatients.Count; ndx++)
				{
					BOL.Patient tmpPatient = (BOL.Patient)this._currentBUM.OriginalUnit.AssignedToPatients[ndx];
					BOL.OrderedUnit orderedUnit = new BOL.OrderedUnit(this._currentBUM.OriginalUnit.BloodUnitGuid, tmpPatient.PatientGuid);
					//saving the list of component orders that are not completed yet
					//after the modification is saved we will check the status of all these orders again
					//if any of them becomes filled the message is sent to Vista (look at the end of this method for that code)
					if (BOL.OrderedComponent.GetStatusIncludingUnitsEligibleForIssue(orderedUnit.OrderedComponentGuid) != Common.TaskStatus.Filled)
						incompleteOrders.Add(orderedUnit.OrderedComponentGuid);
				}
			}

			if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.ReadyToVerifyLabeling(modification), MessageBoxDefaultButton.Button2) == DialogResult.Yes)
			{
				DlgVerifyModifiedUnit dlg = new DlgVerifyModifiedUnit(this._currentBUM.ModifiedUnit, this._currentBUM, 0);

				FormWindowState currentState = this.WindowState;
				this.WindowState = FormWindowState.Minimized;

                dlg.ShowDialogFromLockedParent(this, false);
				if (dlg.DialogResult == DialogResult.Abort) return(false);

				if (dlg.DialogResult == DialogResult.OK)
				{
					this._currentBUM.ModifiedUnit.NewLabelVerificationDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
				}

				this._currentBUM.ModifiedUnit.LabelVerificationFailed = (dlg.LabelMismatchExceptions.Count > 0);
				this.WindowState = currentState;
				this._currentBUM.LabelExceptions = dlg.LabelMismatchExceptions;
			}

			DialogResult _saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("modified unit"));

			if (_saveResult == DialogResult.Yes)
			{
				try
				{
					if (this._currentBUM.Save(Common.UpdateFunction.UC026FrmModifyUnits))
					{
						this.IsDirty = false;
						//Since we've processed the modification, we can drop the locks
						this.ReleaseLocks(this._currentBUM.OriginalUnit.BloodUnitGuid, this._currentBUM.OriginalUnit.BloodUnitMedia.BloodUnitMediaGuid);
					
						//CR 1441 - Check workload before the BUM is removed below
						System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) this._currentBUM.WorkloadCode);
						if(dt!= null)
						{
							if(dt.Rows.Count == 0)
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
							}
						}

						this._bumControlList.RemoveAt(currentTab);
				
						if (this._bumControlList.Count > 0)
						{
							this._removingTabs = true;	
							this.tabOriginals.TabPages.RemoveAt(currentTab);
							this.tabTargets.TabPages.RemoveAt(currentTab);
							this._removingTabs = false;
						}

						retValue = true;
					}
					else
					{
						this.IsDirty = false;	//This will prevent the "Exit without saving" message
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Modified blood unit"));
						return(false);
					}
				}
				catch(Common.RowVersionException)
				{
					this.btnOK.RowVersionException = true;	//CR2077
					this._btnOKRowVersionException[this.CurrentIndex] = true;			//Save this off so the user can keep processing other units
					this.IsDirty = false;
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					return(false);
				}
			}

			//KD checking component orders again to see if any of them became filled
			//if so sending order completion message to Vista - BR_56.31, CR 2300

			for (int i=0; i<incompleteOrders.Count; i++)
			{
				if (BOL.OrderedComponent.GetStatusIncludingUnitsEligibleForIssue((Guid)incompleteOrders[i]) == Common.TaskStatus.Filled)
				{
					DataTable dtOrderedComponent = BOL.OrderedComponent.GetOrderedComponent((Guid)incompleteOrders[i]);
					if (dtOrderedComponent.Rows.Count > 0)
					{
						BOL.OrderedComponent.SendComponentOrderCompletionMessageToVista(dtOrderedComponent.Rows[0][Common.VbecsTables.OrderedComponent.CprsOrderNumber].ToString());
					}
				}
			}
			return(retValue);
		}

		/// <summary>
		/// Sets up the tabs since we can have multiple source/target tabs... Can. Have.
		/// </summary>
		private void CreateTabs()
		{
			//Need to set _removingTabs, because when you add/remove a tab it fires the Tab_SelectedIndex event, which fails
			this._removingTabs = true;

			//Start at 0 so we can name the zero-indexed tab
			for (int ndx=0; ndx < this._bumControlList.Count; ndx++)
			{
				BOL.BloodUnitModification bumControl = (BOL.BloodUnitModification)this._bumControlList[ndx];

				if (ndx == 0)
				{
					//Set our zero tabs otherwise, they'll have the design-time text on them
					this.tabOriginals.TabPages[ndx].Text = bumControl.OriginalUnit.EyeReadableUnitId;
					this.tabTargets.TabPages[ndx].Text = bumControl.ModifiedUnit.NewUnit.EyeReadableUnitId;
				}
				else
				{
					this.tabOriginals.TabPages.Add(new TabPage(bumControl.OriginalUnit.EyeReadableUnitId));
					this.tabTargets.TabPages.Add(new TabPage(bumControl.ModifiedUnit.NewUnit.EyeReadableUnitId));
				}
			}
			
			this._removingTabs = false;
		}


		#endregion

		private void FrmModifyUnits_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			this._keyCode = e.KeyCode;
		}

		private void FrmModifyUnits_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			this._bShift = e.Shift;
		}

		private void tabOriginals_Leave(object sender, System.EventArgs e)
		{
			
			//if shift tab was pressed.
			if(this._bShift && this._keyCode == System.Windows.Forms.Keys.Tab)
			{
				this.GenericLeave(sender, e);
			}
			else
			{
				this.txtOriginalUnitID.Focus();
			}
			this._bShift = false;
		}

		private void GenericLeave(object sender, System.EventArgs e)
		{
			//if shift tab was pressed.
			if(this._bShift && this._keyCode == System.Windows.Forms.Keys.Tab)
			{
				if(this._genericControl != null)
					this._genericControl.Focus();
			}
		}

		private void txtOriginalUnitID_Leave(object sender, System.EventArgs e)
		{
			if(this._bShift && this._keyCode == System.Windows.Forms.Keys.Tab)
			{
				this.tabOriginals.Focus();
			}
		}

		private void txtOriginalRestrictedStatus_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
			//if  tab was pressed.
			if(this._keyCode == System.Windows.Forms.Keys.Tab && this._bShift == false)
			{
				this.tabTargets.Focus();
			}
		}

		private void lvOriginalAssigned_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
			//if  tab was pressed.
			if(this._keyCode == System.Windows.Forms.Keys.Tab && this._bShift == false)
			{
				this.tabTargets.Focus();
			}
		}

		private void lvOriginalAntigens_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
			//if  tab was pressed.
			if(this._keyCode == System.Windows.Forms.Keys.Tab && this._bShift == false)
			{
				this.tabTargets.Focus();
			}
		}

		private void tabTargets_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
			if(this._keyCode == System.Windows.Forms.Keys.Tab && this._bShift ==false)
			{
				this.txtTargetUnitId.Focus();
			}
		}

		private void lvTargetAntigens_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
			if(this._keyCode == System.Windows.Forms.Keys.Tab && this._bShift ==false)
			{
				this.tabSuppliesEquipment.Focus();
			}
		}

		private void lvTargetAssigned_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
			if(this._keyCode == System.Windows.Forms.Keys.Tab && this._bShift ==false)
			{
				this.tabSuppliesEquipment.Focus();
			}
		}

		private void txtTargetRestrictedStatus_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
			if(this._keyCode == System.Windows.Forms.Keys.Tab && this._bShift ==false)
			{
				this.tabSuppliesEquipment.Focus();
			}
		}

		private void FrmModifyUnits_Leave(object sender, System.EventArgs e)
		{
			if(sender != null)
				this._genericControl = (System.Windows.Forms.Control) sender;
		}

		private void btnAddContainer_Leave(object sender, System.EventArgs e)
		{
			if(this._keyCode == System.Windows.Forms.Keys.Tab && this._bShift ==false)
			{
				if(this.btnOK.EnabledButton)
				{
					this.btnOK.Focus();
				}
				else
				{
					this.btnCancel.Focus();
				}
			}
			this.GenericLeave(sender, e);
			
		}

		private void btnAddSupplies_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
			if(this._keyCode == System.Windows.Forms.Keys.Tab && this._bShift ==false)
			{
				if(this.btnOK.EnabledButton)
				{
					this.btnOK.Focus();
				}
				else
				{
					this.btnCancel.Focus();
				}
			}
		}

		private void btnAddEquipment_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
			if(this._keyCode == System.Windows.Forms.Keys.Tab && this._bShift ==false)
			{
				if(this.btnOK.EnabledButton)
				{
					this.btnOK.Focus();
				}
				else
				{
					this.btnCancel.Focus();
				}
			}
		}

		private void btnAddWafer_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
			if(this._keyCode == System.Windows.Forms.Keys.Tab && this._bShift ==false)
			{
				if(this.btnOK.EnabledButton)
				{
					this.btnOK.Focus();
				}
				else
				{
					this.btnCancel.Focus();
				}
			}
		}

		private void txtOriginalProductName_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void txtOriginalABORh_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void txtOriginalExpirationDate_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void txtOriginalUnitStatus_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void txtOriginalDonationType_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void cbOriginalCMVNeg_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void cbOriginalSickleCellNeg_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void txtOriginalRestrictedName_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void txtOriginalRestrictedSSN_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void tabOriginalExtraInfo_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void txtTargetUnitId_Leave(object sender, System.EventArgs e)
		{
			if(this._bShift && this._keyCode == System.Windows.Forms.Keys.Tab)
			{
				this.tabTargets.Focus();
			}
		}

		private void cmbTargetProductName_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void txtTargetABORh_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void txtTargetUnitStatus_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void txtTargetDonationType_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void txtTargetRestrictedName_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void txtTargetRestrictedSSN_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void cbTargetCMVNeg_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void cbTargetSickleCellNeg_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void tabTargetExtraInfo_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void tabSuppliesEquipment_Leave(object sender, System.EventArgs e)
		{
            this.GenericLeave(sender, e);
			if(this._keyCode == System.Windows.Forms.Keys.Tab && this._bShift ==false)
			{
				if(this.btnOK.EnabledButton)
				{
					this.btnOK.Focus();
				}
				else
				{
					this.btnCancel.Focus();
				}
			}
		}

		private void lvContainer_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void lvSupplies_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void lvEquipment_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void lvSCDWafer_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void btnOK_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

		private void btnCancel_Leave(object sender, System.EventArgs e)
		{
			this.GenericLeave(sender, e);
		}

        private void timer1_Tick(object sender, EventArgs e)
        {
            try
            {
                this.timer1.Enabled = false;    //turn off, we only want to fire this once

                bool cont = true;

                if (this._isLoading || this.cmbTargetProductName.SelectedIndex == -1)
                    return;

                System.Diagnostics.Debug.WriteLine("timer1_Tick");

                System.Data.DataRow dr = (System.Data.DataRow)this._targetProductList[cmbTargetProductName.SelectedIndex];

                BOL.BloodProduct tmpProduct = new BOL.BloodProduct((System.Guid)dr[BLOODPRODUCT.BloodProductGuid]);

                //BR_26.11 - check target product type is active -- change here too -- 
                if ( !BOL.BloodProduct.IsBloodProductActive(tmpProduct.BloodProductGuid) || !tmpProduct.IsProductShipperActive(this._currentBUM.ModifiedUnit.NewUnit.IncomingShipment.LocalSupplierGuid))
                {
                    GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.ProductNotActive(tmpProduct.ProductShortName));

                    if (!ActivateBloodProduct(
                        tmpProduct.BloodProductGuid,
                        this._currentBUM.ModifiedUnit.NewUnit.IncomingShipment.LocalSupplier,
                        (this._currentBUM.ModifiedUnit.NewUnit.BarcodeType == Common.BarcodeType.Codabar)))
                    {
                        //If it's not OK, they clicked cancel or problem occurred
                        //According to BR_26.11 - let them pick another??
                        //cont = false;
                        this.cmbTargetProductName.SelectedIndex = -1;
                        return;
                    }
                }

                if (cont)
                {
                    this._currentBUM.ModifiedUnit.TargetBloodProduct = tmpProduct;
                    /*CR2735 - Im not happy about this fix but didnt want a bigger redesign*/
                    this.dtpTargetExpirationDate.Value = this._currentBUM.ModifiedUnit.RecommendedExpirationDateTime(this._currentBUM);
                    //CR3196 - Set the expiration date of the object since we're setting the control's value via code
                    this._currentBUM.ModifiedUnit.UnitExpirationDate = this.dtpTargetExpirationDate.Value;

                    this.toolTip1.SetToolTip(this.cmbTargetProductName, this._currentBUM.ModifiedUnit.TargetBloodProduct.ProductName);
                    this.errError.SetVbecsError(this.cmbTargetProductName, string.Empty); // **** 508 Compliance ***
                }
            }
            catch (Exception err)
            {
                this.errError.SetVbecsError(this.cmbTargetProductName, err.Message); // **** 508 Compliance ***
            }	
        }
	}
}

